<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:html="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwalinks="urn:WebWorks-ALinks-Schema"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwbehaviors="urn:WebWorks-Behaviors-Schema"
                              xmlns:wwnotes="urn:WebWorks-Footnote-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwimaging="urn:WebWorks-XSLT-Extension-Imaging"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwmode wwlinks wwalinks wwfiles wwdoc wwsplits wwtoc wwbehaviors wwnotes wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwunits wwfilesext wwprojext wwimaging wwexsldoc"
>
 <xsl:key name="wwsplits-files-by-groupid-type" match="wwsplits:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwsplits-files-by-source-lowercase" match="wwsplits:File" use="@source-lowercase" />
 <xsl:key name="wwsplits-frames-by-id" match="wwsplits:Frame" use="@id" />
 <xsl:key name="wwsplits-popups-by-id" match="wwsplits:Popup" use="@id" />
 <xsl:key name="wwtoc-entry-by-id" match="wwtoc:Entry" use="@id" />
 <xsl:key name="wwbehaviors-paragraphs-by-id" match="wwbehaviors:Paragraph" use="@id" />
 <xsl:key name="wwbehaviors-paragraphs-by-relatedtopic" match="wwbehaviors:Paragraph" use="@relatedtopic" />
 <xsl:key name="wwbehaviors-frames-by-id" match="wwbehaviors:Frame" use="@id" />
 <xsl:key name="wwbehaviors-tables-by-id" match="wwbehaviors:Table" use="@id" />
 <xsl:key name="wwbehaviors-markers-by-id" match="wwbehaviors:Marker" use="@id" />
 <xsl:key name="wwdoc-paragraphs-by-id" match="wwdoc:Paragraph" use="@id" />
 <xsl:key name="wwdoc-text-by-value" match="wwdoc:Text" use="@value" />
 <xsl:key name="wwnotes-notes-by-id" match="wwnotes:Note" use="@id" />
 <xsl:key name="wwfiles-files-by-path" match="wwfiles:File" use="@path" />
 <xsl:key name="wwproject-property-by-name" match="wwproject:Property" use="@Name"/>


 <xsl:template name="Breadcrumbs">
  <xsl:param name="ParamPageRule" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamBreadcrumbTOCEntry" />

  <xsl:for-each select="$ParamBreadcrumbTOCEntry/../ancestor-or-self::wwtoc:Entry">
   <xsl:variable name="VarTOCEntry" select="." />

   <!-- Emit entry -->
   <!--            -->
   <xsl:choose>
    <xsl:when test="string-length($VarTOCEntry/@path) &gt; 0">
     <!-- Entry with link -->
     <!--                 -->
     <xsl:variable name="VarRelativePath" select="wwuri:GetRelativeTo($VarTOCEntry/@path, $ParamSplit/@path)" />

     <html:a class="WebWorks_Breadcrumb_Link" href="{$VarRelativePath}#{$ParamBreadcrumbTOCEntry/@linkid}">
      <xsl:call-template name="BreadcrumbEntry">
       <xsl:with-param name="ParamTOCEntry" select="$VarTOCEntry" />
      </xsl:call-template>
     </html:a>
    </xsl:when>

    <xsl:otherwise>
     <!-- Entry without link -->
     <!--                    -->
     <xsl:call-template name="BreadcrumbEntry">
      <xsl:with-param name="ParamTOCEntry" select="$VarTOCEntry" />
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>

   <!-- Emit separator -->
   <!--                -->
   <xsl:variable name="VarBreadcrumbsSeparator" select="$ParamPageRule/wwproject:Properties/wwproject:Property[@Name = 'breadcrumbs-separator']/@Value" />
   <xsl:choose>
    <xsl:when test="string-length($VarBreadcrumbsSeparator) &gt; 0">
     <xsl:value-of select="$VarBreadcrumbsSeparator" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:text> : </xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>

  <!-- Emit entry -->
  <!--            -->
  <xsl:call-template name="BreadcrumbEntry">
   <xsl:with-param name="ParamTOCEntry" select="$ParamBreadcrumbTOCEntry" />
  </xsl:call-template>
 </xsl:template>


 <xsl:template name="BreadcrumbEntry">
  <xsl:param name="ParamTOCEntry" />

  <xsl:for-each select="$ParamTOCEntry/wwdoc:Paragraph/wwdoc:Number/wwdoc:Text | $ParamTOCEntry/wwdoc:Paragraph/wwdoc:TextRun/wwdoc:Text">
   <xsl:variable name="VarText" select="." />

   <xsl:value-of select="$VarText/@value" />
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Content-Content">
  <xsl:param name="ParamContent" />
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamTOCData" />
  <xsl:param name="ParamSplit" />

  <!-- Content -->
  <!--         -->
  <xsl:apply-templates select="$ParamContent" mode="wwmode:content">
   <xsl:with-param name="ParamSplits" select="$ParamSplits" />
   <xsl:with-param name="ParamCargo" select="$ParamCargo" />
   <xsl:with-param name="ParamLinks" select="$ParamLinks" />
   <xsl:with-param name="ParamTOCData" select="$ParamTOCData" />
   <xsl:with-param name="ParamSplit" select="$ParamSplit" />
  </xsl:apply-templates>

  <!-- Related Topics -->
  <!--                -->
  <xsl:call-template name="RelatedTopics">
   <xsl:with-param name="ParamContent" select="$ParamContent" />
   <xsl:with-param name="ParamSplits" select="$ParamSplits" />
   <xsl:with-param name="ParamCargo" select="$ParamCargo" />
   <xsl:with-param name="ParamLinks" select="$ParamLinks" />
   <xsl:with-param name="ParamSplit" select="$ParamSplit" />
  </xsl:call-template>
 </xsl:template>


 <xsl:template name="RelatedTopics">
  <xsl:param name="ParamContent" />
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />

  <xsl:variable name="VarRelatedTopicParagraphsAsXML">
   <xsl:call-template name="RelatedTopicParagraphs">
    <xsl:with-param name="ParamContent" select="$ParamContent" />
    <xsl:with-param name="ParamCargo" select="$ParamCargo" />
    <xsl:with-param name="ParamSplit" select="$ParamSplit" />
   </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="VarRelatedTopicParagraphs" select="msxsl:node-set($VarRelatedTopicParagraphsAsXML)/wwdoc:Paragraph" />

  <html:script type="text/javascript" language="JavaScript1.2">
   <xsl:comment>
    <xsl:text>
</xsl:text>
    <xsl:text>          // Clear related topics
</xsl:text>
    <xsl:text>          //
</xsl:text>
    <xsl:text>          WWHClearRelatedTopics();
</xsl:text>

    <xsl:if test="count($VarRelatedTopicParagraphs) &gt; 0">
     <xsl:text>
</xsl:text>
     <xsl:text>          // Add related topics
</xsl:text>
     <xsl:text>          //
</xsl:text>
     <xsl:for-each select="$VarRelatedTopicParagraphs">
      <xsl:variable name="VarRelatedTopicParagraph" select="." />

      <!-- Resolve link -->
      <!--              -->
      <xsl:variable name="VarResolvedLinkInfoAsXML">
       <xsl:call-template name="Links-Resolve">
        <xsl:with-param name="ParamAllowBaggage" select="$ParameterAllowBaggage" />
        <xsl:with-param name="ParamAllowGroupToGroup" select="$ParameterAllowGroupToGroup" />
        <xsl:with-param name="ParamAllowURL" select="$ParameterAllowURL" />
        <xsl:with-param name="ParamBaggageSplitFileType" select="$ParameterBaggageSplitFileType" />
        <xsl:with-param name="ParamProject" select="$GlobalProject" />
        <xsl:with-param name="ParamLinks" select="$ParamLinks" />
        <xsl:with-param name="ParamSplits" select="$ParamSplits" />
        <xsl:with-param name="ParamSplitGroupID" select="$ParamSplit/@groupID" />
        <xsl:with-param name="ParamSplitDocumentID" select="$ParamSplit/@documentID" />
        <xsl:with-param name="ParamDocumentLink" select="$VarRelatedTopicParagraph/wwdoc:Link" />
       </xsl:call-template>
      </xsl:variable>
      <xsl:variable name="VarResolvedLinkInfo" select="msxsl:node-set($VarResolvedLinkInfoAsXML)/wwlinks:ResolvedLink" />

      <xsl:choose>
       <!-- Document -->
       <!--          -->
       <xsl:when test="($VarResolvedLinkInfo/@type = 'document') or ($VarResolvedLinkInfo/@type = 'group') or ($VarResolvedLinkInfo/@type = 'project')">
        <!-- Project link -->
        <!--              -->
        <xsl:variable name="VarGroupName" select="wwprojext:GetGroupName($VarResolvedLinkInfo/@groupID)" />
        <xsl:variable name="VarOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), $VarGroupName)" />
        <xsl:variable name="VarRelativePath" select="wwuri:GetRelativeTo($VarResolvedLinkInfo/@path, wwfilesystem:Combine($VarOutputDirectoryPath, 'dummy.component'))" />

        <!-- Add entry -->
        <!--           -->
        <xsl:text>          </xsl:text>
        <xsl:text>WWHAddRelatedTopic(&quot;</xsl:text>

        <!-- Paragraph text -->
        <!--                -->
        <xsl:for-each select="$VarRelatedTopicParagraph/wwdoc:TextRun/wwdoc:Text">
         <xsl:value-of select="wwstring:JavaScriptEncoding(@value)" />
        </xsl:for-each>
        <xsl:text>&quot;, &quot;</xsl:text>

        <!-- Context -->
        <!--         -->
        <xsl:call-template name="WWHelpContext">
         <xsl:with-param name="ParamProject" select="$GlobalProject" />
         <xsl:with-param name="ParamGroupID" select="$VarResolvedLinkInfo/@groupID" />
        </xsl:call-template>
        <xsl:text>&quot;, &quot;</xsl:text>

        <!-- Link -->
        <!--      -->
        <xsl:value-of select="wwstring:JavaScriptEncoding($VarRelativePath)" />
        <xsl:if test="(string-length($VarRelatedTopicParagraph/wwdoc:Link/@anchor) &gt; 0) and (string-length($VarResolvedLinkInfo/@linkid) &gt; 0)">
         <xsl:text>#</xsl:text>
         <xsl:value-of select="wwstring:JavaScriptEncoding($VarResolvedLinkInfo/@linkid)" />
        </xsl:if>
        <xsl:text>&quot;</xsl:text>
        <xsl:text>);
</xsl:text>
       </xsl:when>
      </xsl:choose>
     </xsl:for-each>
    </xsl:if>

    <xsl:text>
</xsl:text>
    <xsl:text>          document.writeln(WWHRelatedTopicsInlineHTML());
</xsl:text>
    <xsl:text>        // </xsl:text>
   </xsl:comment>
  </html:script>
 </xsl:template>


 <xsl:template name="RelatedTopicParagraphs">
  <xsl:param name="ParamContent" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamSplit" />

  <xsl:for-each select="$ParamCargo/wwbehaviors:Behaviors[1]">
   <xsl:variable name="VarRelatedTopicBehaviorParagraphs" select="key('wwbehaviors-paragraphs-by-relatedtopic', 'define') | key('wwbehaviors-paragraphs-by-relatedtopic', 'define-no-output')" />

   <xsl:for-each select="$VarRelatedTopicBehaviorParagraphs[(@documentposition &gt;= $ParamSplit/@documentstartposition) and (@documentposition &lt;= $ParamSplit/@documentendposition)]">
    <xsl:variable name="VarBehaviorParagraph" select="." />

    <xsl:for-each select="$ParamContent[1]">
     <xsl:for-each select="key('wwdoc-paragraphs-by-id', $VarBehaviorParagraph/@id)[1]">
      <xsl:variable name="VarParagraph" select="." />

      <!-- Paragraph has link? -->
      <!--                     -->
      <xsl:variable name="VarChildLinks" select="$VarParagraph//wwdoc:Link[count($VarParagraph | ancestor::wwdoc:Paragraph[1]) = 1]" />
      <xsl:variable name="VarChildLinksCount" select="count($VarChildLinks)" />
      <xsl:if test="$VarChildLinksCount &gt; 0">
       <!-- Emit paragraph -->
       <!--                -->
       <wwdoc:Paragraph>
        <xsl:copy-of select="$VarParagraph/@*" />

        <!-- Insure link is defined -->
        <!--                        -->
        <xsl:if test="count($VarParagraph/wwdoc:Link) = 0">
         <xsl:copy-of select="$VarChildLinks[1]" />
        </xsl:if>

        <xsl:copy-of select="$VarParagraph/*" />
       </wwdoc:Paragraph>
      </xsl:if>
     </xsl:for-each>
    </xsl:for-each>
   </xsl:for-each>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Content-Notes">
  <xsl:param name="ParamNotes" />
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamTOCData" />
  <xsl:param name="ParamSplit" />

  <xsl:if test="count($ParamNotes[1]) = 1">
   <html:hr />
   <xsl:for-each select="$ParamNotes">
    <xsl:variable name="VarNote" select="." />

    <xsl:variable name="VarNoteNumber" select="$ParamCargo/wwnotes:NoteNumbering/wwnotes:Note[@id = $VarNote/@id]/@number" />

    <xsl:if test="string-length($VarNoteNumber) &gt; 0">
     <html:div style="font-size: smaller; float: left; padding-right: 10px;">
      <html:a name="{$VarNote/@id}">
       <xsl:attribute name="href">
        <xsl:text>#wwfootnote_inline_</xsl:text>
        <xsl:value-of select="$VarNote/@id" />
       </xsl:attribute>

       <xsl:value-of select="$VarNoteNumber"/>
      </html:a>
     </html:div>

     <xsl:apply-templates select="$VarNote/*" mode="wwmode:content">
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamCargo" select="$ParamCargo" />
      <xsl:with-param name="ParamLinks" select="$ParamLinks" />
      <xsl:with-param name="ParamTOCData" select="$ParamTOCData" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     </xsl:apply-templates>
     <html:br style="clear: both;" />
    </xsl:if>
   </xsl:for-each>
  </xsl:if>
 </xsl:template>


 <xsl:template name="Content-Bullet">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamParagraph" />
  <xsl:param name="ParamCharacter" />
  <xsl:param name="ParamImage" />
  <xsl:param name="ParamSeparator" />
  <xsl:param name="ParamStyle" />

  <xsl:choose>
   <xsl:when test="string-length($ParamStyle) &gt; 0">

    <!-- Get rule -->
    <!--          -->
    <xsl:variable name="VarRule" select="wwprojext:GetRule('Character', $ParamStyle)" />

    <!-- Resolve project properties -->
    <!--                            -->
    <xsl:variable name="VarResolvedContextPropertiesAsXML">
     <xsl:call-template name="Properties-ResolveContextRule">
      <xsl:with-param name="ParamDocumentContext" select="$ParamParagraph" />
      <xsl:with-param name="ParamProperties" select="$VarRule/wwproject:Properties/wwproject:Property" />
      <xsl:with-param name="ParamStyleName" select="$ParamStyle" />
      <xsl:with-param name="ParamStyleType" select="'Character'" />
      <xsl:with-param name="ParamContextStyle" select="$ParamParagraph/wwdoc:Number[1]/wwdoc:Style" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarResolvedContextProperties" select="msxsl:node-set($VarResolvedContextPropertiesAsXML)/wwproject:Property" />

    <!-- CSS properties -->
    <!--                -->
    <xsl:variable name="VarCSSPropertiesAsXML">
     <xsl:call-template name="CSS-TranslateProjectProperties">
      <xsl:with-param name="ParamProperties" select="$VarResolvedContextProperties" />
      <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarCSSProperties" select="msxsl:node-set($VarCSSPropertiesAsXML)/wwproject:Property" />

    <!-- Style attribute -->
    <!--                 -->
    <xsl:variable name="VarStyleAttribute">
     <xsl:call-template name="CSS-InlineProperties">
      <xsl:with-param name="ParamProperties" select="$VarCSSProperties" />
     </xsl:call-template>
    </xsl:variable>

    <xsl:variable name="VarTagProperty" select="$VarRule/wwproject:Properties/wwproject:Property[@Name = 'tag']/@Value" />
    <xsl:variable name="VarTag">
     <xsl:choose>
      <xsl:when test="string-length($VarTagProperty) &gt; 0">
       <xsl:value-of select="$VarTagProperty" />
      </xsl:when>

      <xsl:otherwise>
       <xsl:value-of select="'span'" />
      </xsl:otherwise>
     </xsl:choose>
    </xsl:variable>

    <xsl:element name="{$VarTag}" namespace="{$GlobalDefaultNamespace}">
     <!-- Style attribute -->
     <!--                 -->
     <xsl:if test="string-length($VarStyleAttribute) &gt; 0">
      <xsl:attribute name="style">
       <xsl:value-of select="$VarStyleAttribute" />
      </xsl:attribute>
     </xsl:if>

     <xsl:if test="string-length($ParamImage) &gt; 0">
      <!-- Get absolute path for imaging info -->
      <!--                                    -->
      <xsl:variable name="VarImageFileSystemPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwprojext:GetGroupName($ParamSplit/@groupID), $ParamImage)" />
      <xsl:variable name="VarImageInfo" select="wwimaging:GetInfo($VarImageFileSystemPath)" />

      <xsl:variable name="VarImagePath">
       <xsl:call-template name="URI-ResolveProjectFileURI">
        <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
        <xsl:with-param name="ParamSplits" select="$ParamSplits" />
        <xsl:with-param name="ParamURI" select="$ParamImage" />
       </xsl:call-template>
      </xsl:variable>

      <!-- Image -->
      <!--       -->
      <html:img src="{$VarImagePath}" alt="*" border="0" width="{$VarImageInfo/@width}" height="{$VarImageInfo/@height}" />
     </xsl:if>

     <!-- Characters -->
     <!--            -->
     <xsl:value-of select="$ParamCharacter" />

     <!-- Separator -->
     <!--           -->
     <xsl:value-of select="$ParamSeparator" />
    </xsl:element>
   </xsl:when>

   <xsl:otherwise>
    <xsl:if test="string-length($ParamImage) &gt; 0">
     <!-- Get absolute path for imaging info -->
     <!--                                    -->
     <xsl:variable name="VarImageFileSystemPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwprojext:GetGroupName($ParamSplit/@groupID), $ParamImage)" />
     <xsl:variable name="VarImageInfo" select="wwimaging:GetInfo($VarImageFileSystemPath)" />

     <xsl:variable name="VarImagePath">
      <xsl:call-template name="URI-ResolveProjectFileURI">
       <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
       <xsl:with-param name="ParamSplits" select="$ParamSplits" />
       <xsl:with-param name="ParamURI" select="$ParamImage" />
      </xsl:call-template>
     </xsl:variable>

     <!-- Image -->
     <!--       -->
     <html:img src="{$VarImagePath}" alt="*" border="0" width="{$VarImageInfo/@width}" height="{$VarImageInfo/@height}" />
    </xsl:if>

    <!-- Characters -->
    <!--            -->
    <xsl:value-of select="$ParamCharacter" />

    <!-- Separator -->
    <!--           -->
    <xsl:value-of select="$ParamSeparator" />
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template name="Notes-Number">
  <xsl:param name="ParamNotes" />

  <wwnotes:NoteNumbering version="1.0">
   <xsl:for-each select="$ParamNotes">
    <xsl:variable name="VarNote" select="." />

    <wwnotes:Note id="{$VarNote/@id}" number="{position()}" />
   </xsl:for-each>
  </wwnotes:NoteNumbering>
 </xsl:template>


 <xsl:template match="wwdoc:Paragraph" mode="wwmode:content">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamTOCData" />
  <xsl:param name="ParamSplit" />

  <xsl:variable name="VarParagraph" select="." />

  <!-- Aborted? -->
  <!--          -->
  <xsl:if test="not(wwprogress:Abort())">
   <xsl:variable name="VarOverrideRule" select="wwprojext:GetOverrideRule('Paragraph', $VarParagraph/@stylename, $ParamSplit/@documentID, $VarParagraph/@id)" />
   <xsl:variable name="VarGenerateOutputOption" select="$VarOverrideRule/wwproject:Options/wwproject:Option[@Name = 'generate-output']/@Value" />
   <xsl:variable name="VarGenerateOutput" select="(string-length($VarGenerateOutputOption) = 0) or ($VarGenerateOutputOption != 'false')" />
   <xsl:if test="$VarGenerateOutput">
    <!-- Related Topic Only or Popup Only? -->
    <!--                                   -->
    <xsl:for-each select="$ParamCargo/wwbehaviors:Behaviors[1]">
     <xsl:variable name="VarParagraphBehavior" select="key('wwbehaviors-paragraphs-by-id', $VarParagraph/@id)[1]" />
     <xsl:variable name="VarInPopupPage" select="count($ParamCargo/wwbehaviors:PopupPage) &gt; 0" />
     <xsl:variable name="VarPopupOnly" select="($VarParagraphBehavior/@popup = 'define-no-output') or ($VarParagraphBehavior/@popup = 'append-no-output')" />
     <xsl:variable name="VarRelatedTopicOnly" select="$VarParagraphBehavior/@relatedtopic = 'define-no-output'" />

     <xsl:if test="$VarInPopupPage or (not($VarPopupOnly) and not($VarRelatedTopicOnly))">
      <!-- Paragraph -->
      <!--           -->
      <xsl:call-template name="Paragraph">
       <xsl:with-param name="ParamSplits" select="$ParamSplits" />
       <xsl:with-param name="ParamCargo" select="$ParamCargo" />
       <xsl:with-param name="ParamLinks" select="$ParamLinks" />
       <xsl:with-param name="ParamSplit" select="$ParamSplit" />
       <xsl:with-param name="ParamParagraph" select="$VarParagraph" />
       <xsl:with-param name="ParamStyleName" select="$VarParagraph/@stylename" />
       <xsl:with-param name="ParamOverrideRule" select="$VarOverrideRule" />
       <xsl:with-param name="ParamParagraphBehavior" select="$VarParagraphBehavior" />
      </xsl:call-template>

      <!-- MiniTOC -->
      <!--         -->
      <xsl:if test="not($VarInPopupPage)">
       <xsl:variable name="VarMiniTOCSubLevels" select="$VarOverrideRule/wwproject:Options/wwproject:Option[@Name = 'minitoc-sublevels']/@Value" />
       <xsl:variable name="VarMiniTOCSubLevelsNumericPrefix" select="wwunits:NumericPrefix($VarMiniTOCSubLevels)" />
       <xsl:variable name="VarMiniTOCSubLevelsGreaterThanZero" select="(string-length($VarMiniTOCSubLevelsNumericPrefix) &gt; 0) and (number($VarMiniTOCSubLevelsNumericPrefix) &gt; 0)" />
       <xsl:if test="($VarMiniTOCSubLevelsGreaterThanZero) or ($VarMiniTOCSubLevels = 'all')">
        <xsl:for-each select="$ParamTOCData[1]">
         <xsl:variable name="VarTOCEntry" select="key('wwtoc-entry-by-id', $VarParagraph/@id)[@documentID = $ParamSplit/@documentID]" />
         <xsl:for-each select="$VarTOCEntry[1]">
          <xsl:call-template name="MiniTOC">
           <xsl:with-param name="ParamSplit" select="$ParamSplit" />
           <xsl:with-param name="ParamTOCEntry" select="$VarTOCEntry[1]" />
           <xsl:with-param name="ParamEmitTOCEntry" select="false()" />
           <xsl:with-param name="ParamMiniTOCSubLevels" select="$VarMiniTOCSubLevels" />
          </xsl:call-template>
         </xsl:for-each>
        </xsl:for-each>
       </xsl:if>
      </xsl:if>
     </xsl:if>
    </xsl:for-each>
   </xsl:if>
  </xsl:if>
 </xsl:template>


 <xsl:template name="MiniTOC">
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamTOCEntry" />
  <xsl:param name="ParamEmitTOCEntry" />
  <xsl:param name="ParamMiniTOCSubLevels" />

  <xsl:if test="($ParamEmitTOCEntry = true()) or (count($ParamTOCEntry/wwtoc:Entry[1]) = 1)">
   <html:div class="WebWorks_MiniTOC">
    <!-- Emit top-level entry? -->
    <!--                       -->
    <xsl:choose>
     <xsl:when test="$ParamEmitTOCEntry = true()">
      <html:div class="WebWorks_MiniTOC_Level1">
       <!-- Paragraph -->
       <!--           -->
       <xsl:call-template name="MiniTOCParagraph">
        <xsl:with-param name="ParamParagraph" select="$ParamTOCEntry/wwdoc:Paragraph" />
       </xsl:call-template>
      </html:div>

      <!-- Children -->
      <!--          -->
      <xsl:call-template name="MiniTOCEntries">
       <xsl:with-param name="ParamReferencePath" select="$ParamSplit/@path" />
       <xsl:with-param name="ParamParent" select="$ParamTOCEntry" />
       <xsl:with-param name="ParamMiniTOCSubLevels" select="$ParamMiniTOCSubLevels" />
       <xsl:with-param name="ParamLevel" select="2" />
      </xsl:call-template>
     </xsl:when>

     <xsl:otherwise>
      <!-- Children -->
      <!--          -->
      <xsl:call-template name="MiniTOCEntries">
       <xsl:with-param name="ParamReferencePath" select="$ParamSplit/@path" />
       <xsl:with-param name="ParamParent" select="$ParamTOCEntry" />
       <xsl:with-param name="ParamMiniTOCSubLevels" select="$ParamMiniTOCSubLevels" />
       <xsl:with-param name="ParamLevel" select="1" />
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </html:div>
  </xsl:if>
 </xsl:template>


 <xsl:template name="MiniTOCEntries">
  <xsl:param name="ParamReferencePath" />
  <xsl:param name="ParamParent" />
  <xsl:param name="ParamMiniTOCSubLevels" />
  <xsl:param name="ParamLevel" />

  <xsl:variable name="VarSubEntries" select="$ParamParent/wwtoc:Entry" />

  <xsl:for-each select="$VarSubEntries[1]">
   <xsl:for-each select="$VarSubEntries">
    <xsl:variable name="VarEntry" select="." />

    <html:div>
     <xsl:attribute name="class">
      <xsl:text>WebWorks_MiniTOC_Level</xsl:text>
      <xsl:value-of select="$ParamLevel" />
     </xsl:attribute>

     <xsl:choose>
      <xsl:when test="string-length($VarEntry/@path) &gt; 0">
       <!-- Get link -->
       <!--          -->
       <xsl:variable name="VarRelativeLinkPath" select="wwuri:GetRelativeTo($VarEntry/@path, $ParamReferencePath)" />

       <html:a class="WebWorks_MiniTOC_Link" href="{$VarRelativeLinkPath}#{$VarEntry/@linkid}">
        <xsl:call-template name="MiniTOCParagraph">
         <xsl:with-param name="ParamParagraph" select="$VarEntry/wwdoc:Paragraph" />
        </xsl:call-template>
       </html:a>
      </xsl:when>

      <xsl:otherwise>
       <xsl:call-template name="MiniTOCParagraph">
        <xsl:with-param name="ParamParagraph" select="$VarEntry/wwdoc:Paragraph" />
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </html:div>

    <!-- Recurse -->
    <!--         -->
    <xsl:choose>
     <xsl:when test="$ParamMiniTOCSubLevels = 'all'">
      <xsl:call-template name="MiniTOCEntries">
       <xsl:with-param name="ParamReferencePath" select="$ParamReferencePath" />
       <xsl:with-param name="ParamParent" select="$VarEntry" />
       <xsl:with-param name="ParamMiniTOCSubLevels" select="$ParamMiniTOCSubLevels" />
       <xsl:with-param name="ParamLevel" select="$ParamLevel + 1" />
      </xsl:call-template>
     </xsl:when>

     <xsl:when test="($ParamMiniTOCSubLevels - 1) &gt; 0">
      <xsl:call-template name="MiniTOCEntries">
       <xsl:with-param name="ParamReferencePath" select="$ParamReferencePath" />
       <xsl:with-param name="ParamParent" select="$VarEntry" />
       <xsl:with-param name="ParamMiniTOCSubLevels" select="$ParamMiniTOCSubLevels - 1" />
       <xsl:with-param name="ParamLevel" select="$ParamLevel + 1" />
      </xsl:call-template>
     </xsl:when>
    </xsl:choose>
   </xsl:for-each>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="MiniTOCParagraph">
  <xsl:param name="ParamParagraph" />

  <xsl:for-each select="$ParamParagraph/wwdoc:Number/wwdoc:Text | $ParamParagraph/wwdoc:TextRun/wwdoc:Text">
   <xsl:value-of select="@value" />
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Paragraph">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamParagraph" />
  <xsl:param name="ParamStyleName" />
  <xsl:param name="ParamOverrideRule" />
  <xsl:param name="ParamParagraphBehavior" />

  <!-- Preserve empty? -->
  <!--                 -->
  <xsl:variable name="VarPreserveEmptyOption" select="$ParamOverrideRule/wwproject:Options/wwproject:Option[@Name = 'preserve-empty']/@Value" />
  <xsl:variable name="VarPreserveEmpty" select="(string-length($VarPreserveEmptyOption) = 0) or ($VarPreserveEmptyOption = 'true')" />

  <!-- Non-empty text runs -->
  <!--                     -->
  <xsl:variable name="VarTextRuns" select="$ParamParagraph/wwdoc:TextRun[count(child::wwdoc:Text[1] | child::wwdoc:Frame[1] | child::wwdoc:Note[1] | child::wwdoc:LineBreak[1] | child::wwdoc:Marker[1]) &gt; 0]" />

  <!-- Process this paragraph at all? -->
  <!--                                -->
  <xsl:if test="($VarPreserveEmpty) or (count($VarTextRuns[1]) = 1)">
   <!-- Pass-through? -->
   <!--               -->
   <xsl:variable name="VarPassThrough">
    <xsl:variable name="VarPassThroughOption" select="$ParamOverrideRule/wwproject:Options/wwproject:Option[@Name = 'pass-through']/@Value" />

    <xsl:choose>
     <xsl:when test="$VarPassThroughOption = 'true'">
      <xsl:value-of select="true()" />
     </xsl:when>

     <xsl:otherwise>
      <xsl:call-template name="Conditions-PassThrough">
       <xsl:with-param name="ParamConditions" select="$ParamParagraph/wwdoc:Conditions" />
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <!-- A-Link? -->
   <!--         -->
   <xsl:variable name="VarALinkOption" select="$ParamOverrideRule/wwproject:Options/wwproject:Option[@Name = 'alink']/@Value" />
   <xsl:variable name="VarALink" select="$VarALinkOption = 'true'" />

   <xsl:choose>
    <!-- Pass-through -->
    <!--              -->
    <xsl:when test="$VarPassThrough = 'true'">
     <xsl:call-template name="Paragraph-PassThrough">
      <xsl:with-param name="ParamParagraph" select="$ParamParagraph" />
     </xsl:call-template>
    </xsl:when>

    <!-- A-Link around whole paragraph -->
    <!--                               -->
    <xsl:when test="$VarALink">
     <!-- Update cargo -->
     <!--              -->
     <xsl:variable name="VarCargoALinkAsXML">
      <xsl:variable name="VarALinkEntries">
       <xsl:call-template name="ALinkEntries">
        <xsl:with-param name="ParamMarkers" select="$ParamParagraph/wwdoc:TextRun/wwdoc:Marker" />
       </xsl:call-template>
      </xsl:variable>

      <wwalinks:ALink>
       <xsl:attribute name="href">
        <xsl:value-of select="'javascript:WWHDoNothingHREF();'" />
       </xsl:attribute>
       <xsl:attribute name="onClick">
        <xsl:value-of select="concat('WWHShowALinksPopup(new Array(', $VarALinkEntries, '), (document.all||document.getElementById||document.layers)?event:null);')" />
       </xsl:attribute>
      </wwalinks:ALink>
     </xsl:variable>
     <xsl:variable name="VarCargoALink" select="msxsl:node-set($VarCargoALinkAsXML)" />
     <xsl:variable name="VarCargo" select="$ParamCargo/*/.. | $VarCargoALink" />

     <xsl:for-each select="$ParamSplits[1]">
      <!-- Determine image paths -->
      <!--                       -->
      <xsl:variable name="Var_seertup" select="wwuri:GetRelativeTo(key('wwsplits-files-by-source-lowercase', wwstring:ToLower('wwformat:Files/images/seertup.gif'))[1]/@path, $ParamSplit/@path)" />
      <xsl:variable name="Var_seeright" select="wwuri:GetRelativeTo(key('wwsplits-files-by-source-lowercase', wwstring:ToLower('wwformat:Files/images/seeright.gif'))[1]/@path, $ParamSplit/@path)" />
      <xsl:variable name="Var_seelflow" select="wwuri:GetRelativeTo(key('wwsplits-files-by-source-lowercase', wwstring:ToLower('wwformat:Files/images/seelflow.gif'))[1]/@path, $ParamSplit/@path)" />
      <xsl:variable name="Var_seebttm" select="wwuri:GetRelativeTo(key('wwsplits-files-by-source-lowercase', wwstring:ToLower('wwformat:Files/images/seebttm.gif'))[1]/@path, $ParamSplit/@path)" />
      <xsl:variable name="Var_seertlow" select="wwuri:GetRelativeTo(key('wwsplits-files-by-source-lowercase', wwstring:ToLower('wwformat:Files/images/seertlow.gif'))[1]/@path, $ParamSplit/@path)" />

      <html:table border="0" cellspacing="0" cellpadding="0" onclick="{$VarCargo/wwalinks:ALink[1]/@onClick}" summary="">
       <html:tr>
        <html:td height="2" colspan="4" bgcolor="#FFFFFF"></html:td>
        <html:td width="2" height="2" background="{$Var_seertup}"></html:td>
       </html:tr>
       <html:tr>
        <html:td width="2" height="2" bgcolor="#FFFFFF"></html:td>
        <html:td height="2" colspan="3" bgcolor="#EEEEEE"></html:td>
        <html:td width="2" height="2" background="{$Var_seeright}"></html:td>
       </html:tr>
       <html:tr>
        <html:td width="2" bgcolor="#FFFFFF"></html:td>
        <html:td width="2" bgcolor="#EEEEEE"></html:td>
        <html:td bgcolor="#EEEEEE">

         <xsl:call-template name="Paragraph-Normal">
          <xsl:with-param name="ParamSplits" select="$ParamSplits" />
          <xsl:with-param name="ParamCargo" select="$VarCargo" />
          <xsl:with-param name="ParamLinks" select="$ParamLinks" />
          <xsl:with-param name="ParamSplit" select="$ParamSplit" />
          <xsl:with-param name="ParamParagraph" select="$ParamParagraph" />
          <xsl:with-param name="ParamStyleName" select="$ParamStyleName" />
          <xsl:with-param name="ParamOverrideRule" select="$ParamOverrideRule" />
          <xsl:with-param name="ParamParagraphBehavior" select="$ParamParagraphBehavior" />
         </xsl:call-template>

        </html:td>
        <html:td width="2" bgcolor="#EEEEEE"></html:td>
        <html:td width="2" background="{$Var_seeright}"></html:td>
       </html:tr>
       <html:tr>
        <html:td width="2" height="2" bgcolor="#FFFFFF"></html:td>
        <html:td height="2" colspan="3" bgcolor="#EEEEEE"></html:td>
        <html:td width="2" height="2" background="{$Var_seeright}"></html:td>
       </html:tr>
       <html:tr>
        <html:td width="2" height="2" background="{$Var_seelflow}"></html:td>
        <html:td height="2" colspan="3" background="{$Var_seebttm}"></html:td>
        <html:td width="2" height="2" background="{$Var_seertlow}"></html:td>
       </html:tr>
      </html:table>
     </xsl:for-each>
    </xsl:when>

    <xsl:otherwise>
     <xsl:call-template name="Paragraph-Normal">
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamCargo" select="$ParamCargo" />
      <xsl:with-param name="ParamLinks" select="$ParamLinks" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
      <xsl:with-param name="ParamParagraph" select="$ParamParagraph" />
      <xsl:with-param name="ParamStyleName" select="$ParamStyleName" />
      <xsl:with-param name="ParamOverrideRule" select="$ParamOverrideRule" />
      <xsl:with-param name="ParamParagraphBehavior" select="$ParamParagraphBehavior" />
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>


 <xsl:template name="Paragraph-PassThrough">
  <xsl:param name="ParamParagraph" />

  <wwexsldoc:Text disable-output-escaping="yes">
   <xsl:for-each select="$ParamParagraph/wwdoc:TextRun/wwdoc:Text">
    <xsl:variable name="VarText" select="." />

    <xsl:value-of select="$VarText/@value" />
   </xsl:for-each>
  </wwexsldoc:Text>
 </xsl:template>


 <xsl:template name="Paragraph-Normal">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamParagraph" />
  <xsl:param name="ParamStyleName" />
  <xsl:param name="ParamOverrideRule" />
  <xsl:param name="ParamParagraphBehavior" />

  <!-- Resolve project properties -->
  <!--                            -->
  <xsl:variable name="VarResolvedPropertiesAsXML">
   <xsl:call-template name="Properties-ResolveOverrideRule">
    <xsl:with-param name="ParamProperties" select="$ParamOverrideRule/wwproject:Properties/wwproject:Property" />
    <xsl:with-param name="ParamContextStyle" select="$ParamParagraph/wwdoc:Style" />
   </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="VarResolvedProperties" select="msxsl:node-set($VarResolvedPropertiesAsXML)/wwproject:Property" />

  <!-- CSS properties -->
  <!--                -->
  <xsl:variable name="VarCSSPropertiesAsXML">
   <xsl:call-template name="CSS-TranslateProjectProperties">
    <xsl:with-param name="ParamProperties" select="$VarResolvedProperties" />
    <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
    <xsl:with-param name="ParamSplits" select="$ParamSplits" />
   </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="VarCSSProperties" select="msxsl:node-set($VarCSSPropertiesAsXML)/wwproject:Property" />

  <xsl:variable name="VarContextRule" select="wwprojext:GetContextRule('Paragraph', $ParamParagraph/@stylename, $ParamSplit/@documentID, $ParamParagraph/@id)" />

  <!-- Resolve project properties -->
  <!--                            -->
  <xsl:variable name="VarResolvedContextPropertiesAsXML">
   <xsl:call-template name="Properties-ResolveContextRule">
    <xsl:with-param name="ParamDocumentContext" select="$ParamParagraph" />
    <xsl:with-param name="ParamProperties" select="$VarContextRule/wwproject:Properties/wwproject:Property" />
    <xsl:with-param name="ParamStyleName" select="$ParamParagraph/@stylename" />
    <xsl:with-param name="ParamStyleType" select="'Paragraph'" />
    <xsl:with-param name="ParamContextStyle" select="$ParamParagraph/wwdoc:Style" />
   </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="VarResolvedContextProperties" select="msxsl:node-set($VarResolvedContextPropertiesAsXML)/wwproject:Property" />

  <!-- CSS properties -->
  <!--                -->
  <xsl:variable name="VarCSSContextPropertiesAsXML">
   <xsl:call-template name="CSS-TranslateProjectProperties">
    <xsl:with-param name="ParamProperties" select="$VarResolvedContextProperties" />
    <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
    <xsl:with-param name="ParamSplits" select="$ParamSplits" />
   </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="VarCSSContextProperties" select="msxsl:node-set($VarCSSContextPropertiesAsXML)/wwproject:Property" />

  <!-- Use numbering? -->
  <!--                -->
  <xsl:variable name="VarUseNumberingOption" select="$VarContextRule/wwproject:Options/wwproject:Option[@Name = 'use-numbering']/@Value" />
  <xsl:variable name="VarUseNumbering" select="(string-length($VarUseNumberingOption) = 0) or ($VarUseNumberingOption = 'true')" />

  <!-- Text Indent -->
  <!--             -->
  <xsl:variable name="VarTextIndent">
   <xsl:if test="$VarUseNumbering">
    <xsl:variable name="VarOverrideTextIndent" select="$VarCSSProperties[@Name = 'text-indent']/@Value" />
    <xsl:choose>
     <xsl:when test="string-length($VarOverrideTextIndent) &gt; 0">
      <xsl:value-of select="$VarOverrideTextIndent" />
     </xsl:when>

     <xsl:otherwise>
      <!-- Text indent defined? -->
      <!--                      -->
      <xsl:variable name="VarContextTextIndent" select="$VarCSSContextProperties[@Name = 'text-indent']/@Value" />
      <xsl:if test="string-length($VarContextTextIndent) &gt; 0">
       <xsl:value-of select="$VarContextTextIndent" />
      </xsl:if>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
  </xsl:variable>

  <xsl:variable name="VarTextIndentNumericPrefix" select="wwunits:NumericPrefix($VarTextIndent)" />
  <xsl:variable name="VarTextIndentLessThanZero" select="(string-length($VarTextIndentNumericPrefix) &gt; 0) and (number($VarTextIndentNumericPrefix) &lt; 0)" />

  <!-- Use bullet from UI? -->
  <!--                     -->
  <xsl:variable name="VarBulletCharacter" select="$VarContextRule/wwproject:Properties/wwproject:Property[@Name = 'bullet-character']/@Value" />
  <xsl:variable name="VarBulletImage" select="$VarContextRule/wwproject:Properties/wwproject:Property[@Name = 'bullet-image']/@Value" />
  <xsl:variable name="VarBulletSeparator" select="$VarContextRule/wwproject:Properties/wwproject:Property[@Name = 'bullet-separator']/@Value" />
  <xsl:variable name="VarBulletStyle" select="$VarContextRule/wwproject:Properties/wwproject:Property[@Name = 'bullet-style']/@Value" />
  <xsl:variable name="VarIgnoreDocumentNumber" select="(string-length($VarBulletCharacter) &gt; 0) or (string-length($VarBulletImage) &gt; 0) or (string-length($VarBulletSeparator) &gt; 0)" />

  <!-- Is numbered paragraph -->
  <!--                       -->
  <xsl:variable name="VarIsNumberedParagraph" select="($VarTextIndentLessThanZero = true()) and ((count($ParamParagraph/wwdoc:Number[1]) = 1) or (string-length($VarBulletCharacter) &gt; 0) or (string-length($VarBulletImage) &gt; 0) or (string-length($VarBulletSeparator) &gt; 0) or (string-length($VarBulletStyle) &gt; 0))" />

  <!-- Citation -->
  <!--          -->
  <xsl:variable name="VarCitation">
   <xsl:call-template name="Behaviors-Options-OptionMarker">
    <xsl:with-param name="ParamContainer" select="$ParamParagraph" />
    <xsl:with-param name="ParamCargo" select="$ParamCargo" />
    <xsl:with-param name="ParamParagraphID" select="$ParamParagraph/@id" />
    <xsl:with-param name="ParamRule" select="$VarContextRule" />
    <xsl:with-param name="ParamOption" select="'citation'" />
   </xsl:call-template>
  </xsl:variable>

  <!-- Tag -->
  <!--     -->
  <xsl:variable name="VarTagProperty" select="$VarContextRule/wwproject:Properties/wwproject:Property[@Name = 'tag']/@Value" />
  <xsl:variable name="VarTag">
   <xsl:choose>
    <xsl:when test="string-length($VarTagProperty) &gt; 0">
     <xsl:value-of select="$VarTagProperty" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:value-of select="'div'" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

  <!-- Tag to use for outer wrapper -->
  <!--                              -->
  <xsl:variable name="VarOuterTag">
   <xsl:choose>
    <xsl:when test="$VarIsNumberedParagraph = true()">
     <xsl:value-of select="'div'" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:value-of select="$VarTag" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

  <!-- Use character styles? -->
  <!--                       -->
  <xsl:variable name="VarUseCharacterStylesOption" select="$ParamOverrideRule/wwproject:Options/wwproject:Option[@Name = 'use-character-styles']/@Value" />
  <xsl:variable name="VarUseCharacterStyles" select="(string-length($VarUseCharacterStylesOption) = 0) or ($VarUseCharacterStylesOption = 'true')" />

  <!-- Preserve empty? -->
  <!--                 -->
  <xsl:variable name="VarPreserveEmptyOption" select="$ParamOverrideRule/wwproject:Options/wwproject:Option[@Name = 'preserve-empty']/@Value" />
  <xsl:variable name="VarPreserveEmpty" select="(string-length($VarPreserveEmptyOption) = 0) or ($VarPreserveEmptyOption = 'true')" />

  <!-- Begin paragraph emit -->
  <!--                      -->
  <xsl:element name="{$VarOuterTag}" namespace="{$GlobalDefaultNamespace}">
   <!-- Class attribute -->
   <!--                 -->
   <xsl:attribute name="class">
    <xsl:value-of select="wwstring:CSSClassName($ParamStyleName)" />
    <xsl:if test="$VarIsNumberedParagraph = true()">
     <xsl:value-of select="'_outer'" />
    </xsl:if>

    <!-- Additional CSS classes -->
    <!--                        -->
    <xsl:variable name="VarAdditionalCSSClassesOption" select="normalize-space($ParamOverrideRule/wwproject:Options/wwproject:Option[@Name = 'additional-css-classes']/@Value)" />
    <xsl:if test="string-length($VarAdditionalCSSClassesOption) &gt; 0">
     <xsl:text> </xsl:text>
     <xsl:value-of select="$VarAdditionalCSSClassesOption" />
     <xsl:if test="$VarIsNumberedParagraph = true()">
      <xsl:text> WebWorks_Paragraph_List_Outer</xsl:text>
     </xsl:if>
    </xsl:if>
   </xsl:attribute>

   <!-- Style attribute -->
   <!--                 -->
   <xsl:choose>
    <xsl:when test="$VarIsNumberedParagraph = true()">
     <xsl:variable name="VarStyleAttributeOuter">
      <xsl:call-template name="CSS-InlinePropertiesOuter">
       <xsl:with-param name="ParamProperties" select="$VarCSSProperties" />
       <xsl:with-param name="ParamContextProperties" select="$VarCSSContextProperties" />
      </xsl:call-template>
     </xsl:variable>

     <xsl:if test="string-length($VarStyleAttributeOuter) &gt; 0">
      <xsl:attribute name="style">
       <xsl:value-of select="$VarStyleAttributeOuter" />
      </xsl:attribute>
     </xsl:if>
    </xsl:when>

    <xsl:otherwise>
     <xsl:variable name="VarStyleAttribute">
      <xsl:call-template name="CSS-InlineProperties">
       <xsl:with-param name="ParamProperties" select="$VarCSSProperties" />
      </xsl:call-template>
     </xsl:variable>

     <xsl:if test="string-length($VarStyleAttribute) &gt; 0">
      <xsl:attribute name="style">
       <xsl:value-of select="$VarStyleAttribute" />
      </xsl:attribute>
     </xsl:if>
    </xsl:otherwise>
   </xsl:choose>

   <!-- Cite attribute -->
   <!--                -->
   <xsl:if test="string-length($VarCitation) &gt; 0">
    <xsl:attribute name="cite">
     <xsl:value-of select="$VarCitation" />
    </xsl:attribute>
   </xsl:if>

   <!-- Dropdown -->
   <!--          -->
   <xsl:if test="($ParamParagraphBehavior/@dropdown = 'start-open') or ($ParamParagraphBehavior/@dropdown = 'start-closed')">
    <xsl:attribute name="onclick">
     <xsl:value-of select="concat('WebWorks_ToggleDIV(WebWorksRootPath, &quot;wwdd', $ParamParagraph/@id, '&quot;);')" />
    </xsl:attribute>
   </xsl:if>

   <!-- Use numbering? -->
   <!--                -->
   <xsl:choose>
    <!-- Use Number -->
    <!--            -->
    <xsl:when test="$VarUseNumbering">
     <xsl:choose>
      <xsl:when test="(count($ParamParagraph/wwdoc:Number[1]) &gt; 0) or (string-length($VarBulletCharacter) &gt; 0) or  (string-length($VarBulletImage) &gt; 0) or (string-length($VarBulletSeparator) &gt; 0)">
       <xsl:choose>
        <xsl:when test="$VarTextIndentLessThanZero">

         <html:table border="0" cellspacing="0" cellpadding="0" summary="">
          <html:tr style="vertical-align: baseline;">
           <html:td>
            <!-- Emit number with inner class and specific number style attribute -->
            <!--                                                                  -->
            <xsl:element name="{$VarTag}" namespace="{$GlobalDefaultNamespace}">
             <xsl:attribute name="class">
              <xsl:value-of select="wwstring:CSSClassName($ParamStyleName)" />
              <xsl:text>_inner</xsl:text>

              <!-- Additional CSS classes -->
              <!--                        -->
              <xsl:variable name="VarAdditionalCSSClassesOption" select="normalize-space($ParamOverrideRule/wwproject:Options/wwproject:Option[@Name = 'additional-css-classes']/@Value)" />
              <xsl:if test="string-length($VarAdditionalCSSClassesOption) &gt; 0">
               <xsl:text> </xsl:text>
               <xsl:value-of select="$VarAdditionalCSSClassesOption" />
               <xsl:text> WebWorks_Paragraph_List_Inner</xsl:text>
              </xsl:if>
             </xsl:attribute>

             <xsl:variable name="VarTextIndentNumberAsUnits" select="wwunits:NumericPrefix($VarTextIndent)" />
             <xsl:variable name="VarTextIndentUnits" select="wwunits:UnitsSuffix($VarTextIndent)" />

             <xsl:attribute name="style">
              <xsl:value-of select="concat('width: ', 0 - $VarTextIndentNumberAsUnits, $VarTextIndentUnits, '; white-space: nowrap;')" />
              <xsl:call-template name="CSS-InlinePropertiesInnerNumber">
               <xsl:with-param name="ParamProperties" select="$VarCSSProperties" />
              </xsl:call-template>
             </xsl:attribute>

             <xsl:call-template name="Number">
              <xsl:with-param name="ParamSplits" select="$ParamSplits" />
              <xsl:with-param name="ParamCargo" select="$ParamCargo" />
              <xsl:with-param name="ParamLinks" select="$ParamLinks" />
              <xsl:with-param name="ParamSplit" select="$ParamSplit" />
              <xsl:with-param name="ParamParagraph" select="$ParamParagraph" />
              <xsl:with-param name="ParamUseCharacterStyles" select="$VarUseCharacterStyles" />
              <xsl:with-param name="ParamIgnoreDocumentNumber" select="$VarIgnoreDocumentNumber" />
              <xsl:with-param name="ParamCharacter" select="$VarBulletCharacter" />
              <xsl:with-param name="ParamImage" select="$VarBulletImage" />
              <xsl:with-param name="ParamSeparator" select="$VarBulletSeparator" />
              <xsl:with-param name="ParamStyle" select="$VarBulletStyle" />
             </xsl:call-template>
            </xsl:element>
           </html:td>

           <!-- Force second cell to honor first cell width -->
           <!--                                             -->
           <html:td width="100%">
            <xsl:variable name="VarStyleAttributeInnerContent">
             <xsl:call-template name="CSS-InlinePropertiesInnerContent">
              <xsl:with-param name="ParamProperties" select="$VarCSSProperties" />
             </xsl:call-template>
            </xsl:variable>

            <!-- Emit content -->
            <!--              -->
            <xsl:element name="{$VarTag}" namespace="{$GlobalDefaultNamespace}">
             <xsl:attribute name="class">
              <xsl:value-of select="wwstring:CSSClassName($ParamStyleName)" />
              <xsl:text>_inner</xsl:text>

              <!-- Additional CSS classes -->
              <!--                        -->
              <xsl:variable name="VarAdditionalCSSClassesOption" select="normalize-space($ParamOverrideRule/wwproject:Options/wwproject:Option[@Name = 'additional-css-classes']/@Value)" />
              <xsl:if test="string-length($VarAdditionalCSSClassesOption) &gt; 0">
               <xsl:text> </xsl:text>
               <xsl:value-of select="$VarAdditionalCSSClassesOption" />
               <xsl:text> WebWorks_Paragraph_List_Inner</xsl:text>
              </xsl:if>
             </xsl:attribute>
             <xsl:if test="string-length($VarStyleAttributeInnerContent) &gt; 0">
              <xsl:attribute name="style">
               <xsl:value-of select="$VarStyleAttributeInnerContent" />
              </xsl:attribute>
             </xsl:if>

             <!-- Text Runs -->
             <!--           -->
             <xsl:call-template name="ParagraphTextRuns">
              <xsl:with-param name="ParamSplits" select="$ParamSplits" />
              <xsl:with-param name="ParamCargo" select="$ParamCargo" />
              <xsl:with-param name="ParamLinks" select="$ParamLinks" />
              <xsl:with-param name="ParamSplit" select="$ParamSplit" />
              <xsl:with-param name="ParamPreserveEmpty" select="$VarPreserveEmpty" />
              <xsl:with-param name="ParamUseCharacterStyles" select="$VarUseCharacterStyles" />
              <xsl:with-param name="ParamParagraph" select="$ParamParagraph" />
             </xsl:call-template>

             <!-- Dropdown Arrow -->
             <!--                -->
             <xsl:if test="($ParamParagraphBehavior/@dropdown = 'start-open') or ($ParamParagraphBehavior/@dropdown = 'start-closed')">
              <html:script type="text/javascript" language="JavaScript1.2">WebWorks_WriteArrow(WebWorksRootPath, &quot;<xsl:value-of select="concat('wwdd', $ParamParagraph/@id)" />&quot;, <xsl:value-of select="$ParamParagraphBehavior/@dropdown = 'start-open'" />);</html:script>
             </xsl:if>
            </xsl:element>
           </html:td>
          </html:tr>
         </html:table>
        </xsl:when>

        <xsl:otherwise>
         <xsl:call-template name="Number">
          <xsl:with-param name="ParamSplits" select="$ParamSplits" />
          <xsl:with-param name="ParamCargo" select="$ParamCargo" />
          <xsl:with-param name="ParamLinks" select="$ParamLinks" />
          <xsl:with-param name="ParamSplit" select="$ParamSplit" />
          <xsl:with-param name="ParamParagraph" select="$ParamParagraph" />
          <xsl:with-param name="ParamUseCharacterStyles" select="$VarUseCharacterStyles" />
          <xsl:with-param name="ParamIgnoreDocumentNumber" select="$VarIgnoreDocumentNumber" />
          <xsl:with-param name="ParamCharacter" select="$VarBulletCharacter" />
          <xsl:with-param name="ParamImage" select="$VarBulletImage" />
          <xsl:with-param name="ParamSeparator" select="$VarBulletSeparator" />
          <xsl:with-param name="ParamStyle" select="$VarBulletStyle" />
         </xsl:call-template>

         <!-- Text Runs -->
         <!--           -->
         <xsl:call-template name="ParagraphTextRuns">
          <xsl:with-param name="ParamSplits" select="$ParamSplits" />
          <xsl:with-param name="ParamCargo" select="$ParamCargo" />
          <xsl:with-param name="ParamLinks" select="$ParamLinks" />
          <xsl:with-param name="ParamSplit" select="$ParamSplit" />
          <xsl:with-param name="ParamPreserveEmpty" select="$VarPreserveEmpty" />
          <xsl:with-param name="ParamUseCharacterStyles" select="$VarUseCharacterStyles" />
          <xsl:with-param name="ParamParagraph" select="$ParamParagraph" />
         </xsl:call-template>

         <!-- Dropdown Arrow -->
         <!--                -->
         <xsl:if test="($ParamParagraphBehavior/@dropdown = 'start-open') or ($ParamParagraphBehavior/@dropdown = 'start-closed')">
          <html:script type="text/javascript" language="JavaScript1.2">WebWorks_WriteArrow(WebWorksRootPath, &quot;<xsl:value-of select="concat('wwdd', $ParamParagraph/@id)" />&quot;, <xsl:value-of select="$ParamParagraphBehavior/@dropdown = 'start-open'" />);</html:script>
         </xsl:if>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:when>

      <xsl:otherwise>
       <!-- Text Runs -->
       <!--           -->
       <xsl:call-template name="ParagraphTextRuns">
        <xsl:with-param name="ParamSplits" select="$ParamSplits" />
        <xsl:with-param name="ParamCargo" select="$ParamCargo" />
        <xsl:with-param name="ParamLinks" select="$ParamLinks" />
        <xsl:with-param name="ParamSplit" select="$ParamSplit" />
        <xsl:with-param name="ParamPreserveEmpty" select="$VarPreserveEmpty" />
        <xsl:with-param name="ParamUseCharacterStyles" select="$VarUseCharacterStyles" />
        <xsl:with-param name="ParamParagraph" select="$ParamParagraph" />
       </xsl:call-template>

       <!-- Dropdown Arrow -->
       <!--                -->
       <xsl:if test="($ParamParagraphBehavior/@dropdown = 'start-open') or ($ParamParagraphBehavior/@dropdown = 'start-closed')">
        <html:script type="text/javascript" language="JavaScript1.2">WebWorks_WriteArrow(WebWorksRootPath, &quot;<xsl:value-of select="concat('wwdd', $ParamParagraph/@id)" />&quot;, <xsl:value-of select="$ParamParagraphBehavior/@dropdown = 'start-open'" />);</html:script>
       </xsl:if>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:when>

    <!-- Skip Number -->
    <!--             -->
    <xsl:otherwise>
     <!-- Text Runs -->
     <!--           -->
     <xsl:call-template name="ParagraphTextRuns">
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamCargo" select="$ParamCargo" />
      <xsl:with-param name="ParamLinks" select="$ParamLinks" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
      <xsl:with-param name="ParamPreserveEmpty" select="$VarPreserveEmpty" />
      <xsl:with-param name="ParamUseCharacterStyles" select="$VarUseCharacterStyles" />
      <xsl:with-param name="ParamParagraph" select="$ParamParagraph" />
     </xsl:call-template>

     <!-- Dropdown Arrow -->
     <!--                -->
     <xsl:if test="($ParamParagraphBehavior/@dropdown = 'start-open') or ($ParamParagraphBehavior/@dropdown = 'start-closed')">
      <html:script type="text/javascript" language="JavaScript1.2">WebWorks_WriteArrow(WebWorksRootPath, &quot;<xsl:value-of select="concat('wwdd', $ParamParagraph/@id)" />&quot;, <xsl:value-of select="$ParamParagraphBehavior/@dropdown = 'start-open'" />);</html:script>
     </xsl:if>
    </xsl:otherwise>
   </xsl:choose>

  <!-- End paragraph emit -->
  <!--                    -->
  </xsl:element>

  <!-- Dropdown Start -->
  <!--                -->
  <xsl:if test="($ParamParagraphBehavior/@dropdown = 'start-open') or ($ParamParagraphBehavior/@dropdown = 'start-closed')">
   <html:script type="text/javascript" language="JavaScript1.2">WebWorks_WriteDIVOpen(&quot;<xsl:value-of select="concat('wwdd', $ParamParagraph/@id)" />&quot;, <xsl:value-of select="$ParamParagraphBehavior/@dropdown = 'start-open'" />);</html:script>
  </xsl:if>

  <!-- Dropdown End -->
  <!--              -->
  <xsl:if test="$ParamParagraphBehavior/@dropdown = 'end'">
   <html:script type="text/javascript" language="JavaScript1.2">WebWorks_WriteDIVClose();</html:script>
  </xsl:if>
 </xsl:template>


 <xsl:template name="Number">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamParagraph" />
  <xsl:param name="ParamUseCharacterStyles" />
  <xsl:param name="ParamIgnoreDocumentNumber" />
  <xsl:param name="ParamCharacter" />
  <xsl:param name="ParamImage" />
  <xsl:param name="ParamSeparator" />
  <xsl:param name="ParamStyle" />

  <xsl:choose>
   <xsl:when test="$ParamIgnoreDocumentNumber">
    <xsl:call-template name="Content-Bullet">
     <xsl:with-param name="ParamSplits" select="$ParamSplits" />
     <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     <xsl:with-param name="ParamParagraph" select="$ParamParagraph" />
     <xsl:with-param name="ParamCharacter" select="$ParamCharacter" />
     <xsl:with-param name="ParamImage" select="$ParamImage" />
     <xsl:with-param name="ParamSeparator" select="$ParamSeparator" />
     <xsl:with-param name="ParamStyle" select="$ParamStyle" />
    </xsl:call-template>
   </xsl:when>

   <xsl:otherwise>
    <xsl:variable name="VarBulletPropertiesAsXML">
     <wwproject:BulletProperties>
      <wwproject:Property Name="bullet-style" Value="{$ParamStyle}" />
     </wwproject:BulletProperties>
    </xsl:variable>
    <xsl:variable name="VarBulletProperties" select="msxsl:node-set($VarBulletPropertiesAsXML)" />

    <xsl:variable name="VarCargo" select="$ParamCargo/*[local-name() != 'BulletProperties']/.. | $VarBulletProperties" />

    <xsl:call-template name="TextRun">
     <xsl:with-param name="ParamSplits" select="$ParamSplits" />
     <xsl:with-param name="ParamCargo" select="$VarCargo" />
     <xsl:with-param name="ParamLinks" select="$ParamLinks" />
     <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     <xsl:with-param name="ParamParagraphID" select="$ParamParagraph/@id" />
     <xsl:with-param name="ParamUseCharacterStyles" select="$ParamUseCharacterStyles" />
     <xsl:with-param name="ParamTextRun" select="$ParamParagraph/wwdoc:Number[1]" />
     <xsl:with-param name="ParamEmitAnchorName" select="false()" />
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template name="ParagraphTextRuns">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamPreserveEmpty" />
  <xsl:param name="ParamUseCharacterStyles" />
  <xsl:param name="ParamParagraph" />

  <!-- Prevent whitespace issues with preformatted text blocks -->
  <!--                                                         -->
  <wwexsldoc:NoBreak />

  <!-- Non-empty text runs -->
  <!--                     -->
  <xsl:variable name="VarTextRuns" select="$ParamParagraph/wwdoc:TextRun[count(child::wwdoc:Text[1] | child::wwdoc:Frame[1] | child::wwdoc:Note[1] | child::wwdoc:LineBreak[1] | child::wwdoc:Marker[1]) &gt; 0]" />
  <xsl:variable name="VarNonMarkerTextRuns" select="$ParamParagraph/wwdoc:TextRun[count(child::wwdoc:Text[1] | child::wwdoc:Frame[1] | child::wwdoc:Note[1] | child::wwdoc:LineBreak[1]) &gt; 0]" />

  <!-- Check for empty paragraphs -->
  <!--                            -->
  <xsl:choose>
   <xsl:when test="count($VarTextRuns[1]) = 1">
    <!-- Paragraph has content -->
    <!--                       -->
    <xsl:for-each select="$VarTextRuns">
     <xsl:variable name="VarTextRun" select="." />

     <xsl:call-template name="TextRun">
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamCargo" select="$ParamCargo" />
      <xsl:with-param name="ParamLinks" select="$ParamLinks" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
      <xsl:with-param name="ParamParagraphID" select="$ParamParagraph/@id" />
      <xsl:with-param name="ParamUseCharacterStyles" select="$ParamUseCharacterStyles" />
      <xsl:with-param name="ParamTextRun" select="$VarTextRun" />
      <xsl:with-param name="ParamEmitAnchorName" select="count($VarTextRun | $VarNonMarkerTextRuns[1]) = 1" />
     </xsl:call-template>
    </xsl:for-each>
   </xsl:when>

   <xsl:otherwise>
    <!-- Empty paragraph! -->
    <!--                  -->
    <xsl:if test="$ParamPreserveEmpty">
     <html:a name="{$ParamParagraph/@id}">&#160;</html:a>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template name="SplitOnSemicolon">
  <xsl:param name="ParamString" />

  <xsl:choose>
   <xsl:when test="contains($ParamString, ';')">
    <xsl:variable name="VarPrefix" select="substring-before($ParamString, ';')" />
    <xsl:variable name="VarSuffix" select="substring-after($ParamString, ';')" />

    <xsl:call-template name="SplitOnSemicolon">
     <xsl:with-param name="ParamString" select="$VarPrefix" />
    </xsl:call-template>
    <xsl:call-template name="SplitOnSemicolon">
     <xsl:with-param name="ParamString" select="$VarSuffix" />
    </xsl:call-template>
   </xsl:when>

   <xsl:otherwise>
    <xsl:variable name="VarNormalizedString" select="normalize-space($ParamString)" />

    <xsl:if test="string-length($VarNormalizedString) &gt; 0">
     <wwdoc:Text value="{$VarNormalizedString}" />
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template name="ALinkEntries">
  <xsl:param name="ParamMarkers" />

  <xsl:variable name="VarALinkKeywordsAsXML">
   <xsl:for-each select="$ParamMarkers">
    <xsl:variable name="VarMarker" select="." />

    <xsl:variable name="VarMarkerRule" select="wwprojext:GetRule('Marker', $VarMarker/@name)" />
    <xsl:variable name="VarMarkerType" select="$VarMarkerRule/wwproject:Options/wwproject:Option[@Name = 'marker-type']/@Value" />

    <xsl:if test="$VarMarkerType = 'alink-link-keywords'">
     <xsl:variable name="VarMarkerText">
      <xsl:for-each select="$VarMarker/wwdoc:TextRun/wwdoc:Text">
       <xsl:value-of select="@value" />
      </xsl:for-each>
     </xsl:variable>

     <xsl:call-template name="SplitOnSemicolon">
      <xsl:with-param name="ParamString" select="$VarMarkerText" />
     </xsl:call-template>
    </xsl:if>
   </xsl:for-each>
  </xsl:variable>
  <xsl:variable name="VarALinkKeywords" select="msxsl:node-set($VarALinkKeywordsAsXML)/*" />

  <xsl:variable name="VarALinkUniqueKeywordsAsXML">
   <xsl:for-each select="$VarALinkKeywords">
    <xsl:variable name="VarText" select="." />

    <xsl:if test="count($VarText | key('wwdoc-text-by-value', $VarText/@value)[1]) = 1">
     <xsl:copy-of select="$VarText" />
    </xsl:if>
   </xsl:for-each>
  </xsl:variable>
  <xsl:variable name="VarALinkUniqueKeywords" select="msxsl:node-set($VarALinkUniqueKeywordsAsXML)/*" />

  <xsl:for-each select="$VarALinkUniqueKeywords">
   <xsl:variable name="VarText" select="." />

   <xsl:value-of select="concat('&quot;', $VarText/@value, '&quot;')" />
   <xsl:if test="position() != last()">
    <xsl:value-of select="', '" />
   </xsl:if>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="LinkInfo">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamDocumentLink" />

  <xsl:element name="LinkInfo" namespace="urn:WebWorks-Engine-Links-Schema">
   <xsl:if test="count($ParamDocumentLink) &gt; 0">
    <!-- Resolve link -->
    <!--              -->
    <xsl:variable name="VarResolvedLinkInfoAsXML">
     <xsl:call-template name="Links-Resolve">
      <xsl:with-param name="ParamAllowBaggage" select="$ParameterAllowBaggage" />
      <xsl:with-param name="ParamAllowGroupToGroup" select="$ParameterAllowGroupToGroup" />
      <xsl:with-param name="ParamAllowURL" select="$ParameterAllowURL" />
      <xsl:with-param name="ParamBaggageSplitFileType" select="$ParameterBaggageSplitFileType" />
      <xsl:with-param name="ParamProject" select="$GlobalProject" />
      <xsl:with-param name="ParamLinks" select="$ParamLinks" />
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamSplitGroupID" select="$ParamSplit/@groupID" />
      <xsl:with-param name="ParamSplitDocumentID" select="$ParamSplit/@documentID" />
      <xsl:with-param name="ParamDocumentLink" select="$ParamDocumentLink" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarResolvedLinkInfo" select="msxsl:node-set($VarResolvedLinkInfoAsXML)/wwlinks:ResolvedLink" />

    <!-- @title -->
    <!--        -->
    <xsl:if test="string-length($VarResolvedLinkInfo/@title) &gt; 0">
     <xsl:attribute name="title">
      <xsl:value-of select="$VarResolvedLinkInfo/@title" />
     </xsl:attribute>
    </xsl:if>

    <xsl:choose>
     <!-- Baggage -->
     <!--         -->
     <xsl:when test="$VarResolvedLinkInfo/@type = 'baggage'">
      <xsl:variable name="VarRelativePath" select="wwuri:GetRelativeTo($VarResolvedLinkInfo/@path, $ParamSplit/@path)" />

      <xsl:attribute name="href">
       <xsl:value-of select="$VarRelativePath" />
      </xsl:attribute>

      <xsl:variable name="VarTarget" select="wwprojext:GetFormatSetting('baggage-file-target', 'external_window')" />

      <xsl:if test="(string-length($VarTarget) &gt; 0) and ($VarTarget != 'none')">
       <xsl:attribute name="target">
        <xsl:value-of select="$VarTarget" />
       </xsl:attribute>
      </xsl:if>
     </xsl:when>

     <!-- Document -->
     <!--          -->
     <xsl:when test="($VarResolvedLinkInfo/@type = 'document') or ($VarResolvedLinkInfo/@type = 'group') or ($VarResolvedLinkInfo/@type = 'project')">
      <!-- Valid link -->
      <!--            -->
      <xsl:variable name="VarGroupName" select="wwprojext:GetGroupName($VarResolvedLinkInfo/@groupID)" />
      <xsl:variable name="VarOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), $VarGroupName)" />
      <xsl:variable name="VarLinkPath" select="wwuri:GetRelativeTo($VarResolvedLinkInfo/@path, wwfilesystem:Combine($VarOutputDirectoryPath, 'dummy.component'))" />
      <xsl:variable name="VarPopupPath">
       <xsl:for-each select="$GlobalProjectSplits[1]">
        <xsl:variable name="VarSplitsPopups" select="key('wwsplits-popups-by-id', $VarResolvedLinkInfo/@linkid)[@documentID = $VarResolvedLinkInfo/@documentID]" />
        <xsl:for-each select="$VarSplitsPopups[1]">
         <xsl:variable name="VarSplitsPopup" select="." />

         <xsl:value-of select="wwuri:GetRelativeTo($VarSplitsPopup/@path, wwfilesystem:Combine($VarOutputDirectoryPath, 'dummy.component'))" />
        </xsl:for-each>
       </xsl:for-each>
      </xsl:variable>

      <!-- Popup only? -->
      <!--             -->
      <xsl:attribute name="href">
       <!-- JavaScript Link -->
       <!--                 -->
       <xsl:text>javascript:WWHClickedPopup('</xsl:text>

       <!-- Context -->
       <!--         -->
       <xsl:call-template name="WWHelpContext">
        <xsl:with-param name="ParamProject" select="$GlobalProject" />
        <xsl:with-param name="ParamGroupID" select="$VarResolvedLinkInfo/@groupID" />
       </xsl:call-template>
       <xsl:text>', '</xsl:text>

       <!-- Link -->
       <!--      -->
       <xsl:if test="(string-length($VarResolvedLinkInfo/@popup-only) = 0) or ($VarResolvedLinkInfo/@popup-only != 'true')">
        <xsl:value-of select="wwstring:JavaScriptEncoding($VarLinkPath)" />
        <xsl:if test="(string-length($ParamDocumentLink/@anchor) &gt; 0) and (string-length($VarResolvedLinkInfo/@linkid) &gt; 0)">
         <xsl:text>#</xsl:text>
         <xsl:value-of select="wwstring:JavaScriptEncoding($VarResolvedLinkInfo/@linkid)" />
        </xsl:if>
       </xsl:if>
       <xsl:text>', '</xsl:text>

       <!-- Popup Link -->
       <!--            -->
       <xsl:value-of select="wwstring:JavaScriptEncoding($VarPopupPath)" />
       <xsl:text>');</xsl:text>
      </xsl:attribute>

      <!-- Popup -->
      <!--       -->
      <xsl:if test="$VarResolvedLinkInfo/@popup = 'true'">
       <xsl:attribute name="onMouseOver">
        <!-- JavaScript Link -->
        <!--                 -->
        <xsl:text>javascript:WWHShowPopup('</xsl:text>

        <!-- Context -->
        <!--         -->
        <xsl:call-template name="WWHelpContext">
         <xsl:with-param name="ParamProject" select="$GlobalProject" />
         <xsl:with-param name="ParamGroupID" select="$VarResolvedLinkInfo/@groupID" />
        </xsl:call-template>
        <xsl:text>', '</xsl:text>

        <!-- Popup Link -->
        <!--            -->
        <xsl:value-of select="wwstring:JavaScriptEncoding($VarPopupPath)" />
        <xsl:text>', (document.all||document.getElementById||document.layers)?event:null);</xsl:text>
       </xsl:attribute>

       <xsl:attribute name="onMouseOut">
        <xsl:text>WWHHidePopup();</xsl:text>
       </xsl:attribute>
      </xsl:if>
     </xsl:when>

     <!-- URL -->
     <!--     -->
     <xsl:when test="$VarResolvedLinkInfo/@type = 'url'">
      <xsl:attribute name="href">
       <xsl:value-of select="$VarResolvedLinkInfo/@url" />
      </xsl:attribute>

      <!-- External URL Target -->
      <!--                     -->
      <xsl:if test="not(wwuri:IsFile($VarResolvedLinkInfo/@url))">
       <xsl:variable name="VarTarget" select="wwprojext:GetFormatSetting('external-url-target', 'external_window')" />

       <xsl:if test="(string-length($VarTarget) &gt; 0) and ($VarTarget != 'none')">
        <xsl:attribute name="target">
         <xsl:value-of select="$VarTarget" />
        </xsl:attribute>
       </xsl:if>
      </xsl:if>
     </xsl:when>
    </xsl:choose>
   </xsl:if>
  </xsl:element>
 </xsl:template>


 <xsl:template name="TextRun">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamParagraphID" />
  <xsl:param name="ParamUseCharacterStyles" />
  <xsl:param name="ParamTextRun" />
  <xsl:param name="ParamEmitAnchorName" />

  <!-- Get rule -->
  <!--          -->
  <xsl:variable name="VarRule" select="wwprojext:GetRule('Character', $ParamTextRun/@stylename)" />

  <!-- Generate output? -->
  <!---                 -->
  <xsl:variable name="VarGenerateOutputOption" select="$VarRule/wwproject:Options/wwproject:Option[@Name = 'generate-output']/@Value" />
  <xsl:variable name="VarGenerateOutput" select="(string-length($VarGenerateOutputOption) = 0) or ($VarGenerateOutputOption != 'false')" />
  <xsl:if test="$VarGenerateOutput">
   <!-- Pass-through? -->
   <!--               -->
   <xsl:variable name="VarPassThrough">
    <xsl:variable name="VarPassThroughOption" select="$VarRule/wwproject:Options/wwproject:Option[@Name = 'pass-through']/@Value" />

    <xsl:choose>
     <xsl:when test="$VarPassThroughOption = 'true'">
      <xsl:value-of select="true()" />
     </xsl:when>

     <xsl:otherwise>
      <xsl:call-template name="Conditions-PassThrough">
       <xsl:with-param name="ParamConditions" select="$ParamTextRun/wwdoc:Conditions" />
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <xsl:choose>
    <xsl:when test="$VarPassThrough = 'true'">
     <xsl:call-template name="TextRun-PassThrough">
      <xsl:with-param name="ParamTextRun" select="$ParamTextRun" />
     </xsl:call-template>
    </xsl:when>

    <xsl:otherwise>
     <!-- A-Link? -->
     <!--         -->
     <xsl:variable name="VarALinkOption" select="$VarRule/wwproject:Options/wwproject:Option[@Name = 'alink']/@Value" />
     <xsl:variable name="VarALink" select="$VarALinkOption = 'true'" />

     <xsl:choose>
      <!-- Handle A-Links -->
      <!--                -->
      <xsl:when test="(count($ParamCargo/wwalinks:ALink[1]) = 0) and ($VarALink)">
       <!-- Update cargo -->
       <!--              -->
       <xsl:variable name="VarCargoALinkAsXML">
        <xsl:variable name="VarALinkEntries">
         <xsl:call-template name="ALinkEntries">
          <xsl:with-param name="ParamMarkers" select="$ParamTextRun/wwdoc:Marker" />
         </xsl:call-template>
        </xsl:variable>

        <wwalinks:ALink>
         <xsl:attribute name="href">
          <xsl:value-of select="'javascript:WWHDoNothingHREF();'" />
         </xsl:attribute>
         <xsl:attribute name="onClick">
          <xsl:value-of select="concat('WWHShowALinksPopup(new Array(', $VarALinkEntries, '), (document.all||document.getElementById||document.layers)?event:null);')" />
         </xsl:attribute>
        </wwalinks:ALink>
       </xsl:variable>
       <xsl:variable name="VarCargoALink" select="msxsl:node-set($VarCargoALinkAsXML)" />
       <xsl:variable name="VarCargo" select="$ParamCargo/*/.. | $VarCargoALink" />

       <xsl:call-template name="TextRun-Normal">
        <xsl:with-param name="ParamSplits" select="$ParamSplits" />
        <xsl:with-param name="ParamCargo" select="$VarCargo" />
        <xsl:with-param name="ParamLinks" select="$ParamLinks" />
        <xsl:with-param name="ParamSplit" select="$ParamSplit" />
        <xsl:with-param name="ParamParagraphID" select="$ParamParagraphID" />
        <xsl:with-param name="ParamUseCharacterStyles" select="$ParamUseCharacterStyles" />
        <xsl:with-param name="ParamTextRun" select="$ParamTextRun" />
        <xsl:with-param name="ParamRule" select="$VarRule" />
        <xsl:with-param name="ParamEmitAnchorName" select="$ParamEmitAnchorName" />
       </xsl:call-template>
      </xsl:when>

      <xsl:otherwise>
       <xsl:call-template name="TextRun-Normal">
        <xsl:with-param name="ParamSplits" select="$ParamSplits" />
        <xsl:with-param name="ParamCargo" select="$ParamCargo" />
        <xsl:with-param name="ParamLinks" select="$ParamLinks" />
        <xsl:with-param name="ParamSplit" select="$ParamSplit" />
        <xsl:with-param name="ParamParagraphID" select="$ParamParagraphID" />
        <xsl:with-param name="ParamUseCharacterStyles" select="$ParamUseCharacterStyles" />
        <xsl:with-param name="ParamTextRun" select="$ParamTextRun" />
        <xsl:with-param name="ParamRule" select="$VarRule" />
        <xsl:with-param name="ParamEmitAnchorName" select="$ParamEmitAnchorName" />
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>


 <xsl:template name="TextRun-PassThrough">
  <xsl:param name="ParamTextRun" />

  <wwexsldoc:Text disable-output-escaping="yes">
   <xsl:for-each select="$ParamTextRun/wwdoc:Text">
    <xsl:variable name="VarText" select="." />

    <xsl:value-of select="$VarText/@value" />
   </xsl:for-each>
  </wwexsldoc:Text>
 </xsl:template>


 <xsl:template name="TextRun-Normal">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamParagraphID" />
  <xsl:param name="ParamUseCharacterStyles" />
  <xsl:param name="ParamTextRun" />
  <xsl:param name="ParamRule" />
  <xsl:param name="ParamEmitAnchorName" />

  <xsl:choose>
   <xsl:when test="($ParamUseCharacterStyles) and ((string-length($ParamTextRun/@stylename) &gt; 0) or (count($ParamTextRun/wwdoc:Style) = 1))">
    <!-- Get override rule -->
    <!--                   -->
    <xsl:variable name="VarOverrideRule" select="wwprojext:GetOverrideRule('Character', $ParamTextRun/@stylename, $ParamSplit/@documentID, $ParamTextRun/@id)" />

    <!-- Resolve project properties -->
    <!--                            -->
    <xsl:variable name="VarResolvedPropertiesAsXML">
     <xsl:call-template name="Properties-ResolveOverrideRule">
      <xsl:with-param name="ParamProperties" select="$VarOverrideRule/wwproject:Properties/wwproject:Property" />
      <xsl:with-param name="ParamContextStyle" select="$ParamTextRun/wwdoc:Style" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarResolvedProperties" select="msxsl:node-set($VarResolvedPropertiesAsXML)/wwproject:Property" />

    <!-- CSS properties -->
    <!--                -->
    <xsl:variable name="VarCSSPropertiesAsXML">
     <xsl:call-template name="CSS-TranslateProjectProperties">
      <xsl:with-param name="ParamProperties" select="$VarResolvedProperties" />
      <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarCSSProperties" select="msxsl:node-set($VarCSSPropertiesAsXML)/wwproject:Property" />

    <!-- Abbreviation -->
    <!--              -->
    <xsl:variable name="VarAbbreviationTitle">
     <xsl:call-template name="Behaviors-Options-OptionMarker">
      <xsl:with-param name="ParamContainer" select="$ParamTextRun" />
      <xsl:with-param name="ParamCargo" select="$ParamCargo" />
      <xsl:with-param name="ParamParagraphID" select="$ParamParagraphID" />
      <xsl:with-param name="ParamRule" select="$ParamRule" />
      <xsl:with-param name="ParamOption" select="'abbreviation'" />
     </xsl:call-template>
    </xsl:variable>

    <!-- Acronym -->
    <!--         -->
    <xsl:variable name="VarAcronymTitle">
     <xsl:call-template name="Behaviors-Options-OptionMarker">
      <xsl:with-param name="ParamContainer" select="$ParamTextRun" />
      <xsl:with-param name="ParamCargo" select="$ParamCargo" />
      <xsl:with-param name="ParamParagraphID" select="$ParamParagraphID" />
      <xsl:with-param name="ParamRule" select="$ParamRule" />
      <xsl:with-param name="ParamOption" select="'acronym'" />
     </xsl:call-template>
    </xsl:variable>

    <!-- Citation -->
    <!--          -->
    <xsl:variable name="VarCitation">
     <xsl:call-template name="Behaviors-Options-OptionMarker">
      <xsl:with-param name="ParamContainer" select="$ParamTextRun" />
      <xsl:with-param name="ParamCargo" select="$ParamCargo" />
      <xsl:with-param name="ParamParagraphID" select="$ParamParagraphID" />
      <xsl:with-param name="ParamRule" select="$ParamRule" />
      <xsl:with-param name="ParamOption" select="'citation'" />
     </xsl:call-template>
    </xsl:variable>

    <!-- Tag -->
    <!--     -->
    <xsl:variable name="VarTagProperty" select="$ParamRule/wwproject:Properties/wwproject:Property[@Name = 'tag']/@Value" />
    <xsl:variable name="VarTag">
     <xsl:choose>
      <xsl:when test="string-length($VarAbbreviationTitle) &gt; 0">
       <xsl:value-of select="'abbr'" />
      </xsl:when>
      <xsl:when test="string-length($VarAcronymTitle) &gt; 0">
       <xsl:value-of select="'acronym'" />
      </xsl:when>
      <xsl:when test="string-length($VarCitation) &gt; 0">
       <xsl:value-of select="'q'" />
      </xsl:when>
      <xsl:otherwise>
       <xsl:choose>
        <xsl:when test="string-length($VarTagProperty) &gt; 0">
         <xsl:value-of select="$VarTagProperty" />
        </xsl:when>

        <xsl:otherwise>
         <xsl:value-of select="'span'" />
        </xsl:otherwise>
       </xsl:choose>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:variable>

    <!-- Class attribute -->
    <!--                 -->
    <xsl:variable name="VarClassAttribute">
     <xsl:choose>
      <xsl:when test="string-length($ParamCargo/wwproject:BulletProperties/wwproject:Property[@Name = 'bullet-style']/@Value) &gt; 0">
       <xsl:value-of select="wwstring:CSSClassName($ParamCargo/wwproject:BulletProperties/wwproject:Property[@Name = 'bullet-style']/@Value)" />
      </xsl:when>

      <xsl:otherwise>
       <xsl:value-of select="wwstring:CSSClassName($ParamTextRun/@stylename)" />
      </xsl:otherwise>
     </xsl:choose>

     <!-- Additional CSS classes -->
     <!--                        -->
     <xsl:variable name="VarAdditionalCSSClassesOption" select="normalize-space($VarOverrideRule/wwproject:Options/wwproject:Option[@Name = 'additional-css-classes']/@Value)" />
     <xsl:if test="string-length($VarAdditionalCSSClassesOption) &gt; 0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="$VarAdditionalCSSClassesOption" />
     </xsl:if>
    </xsl:variable>

    <!-- Style attribute -->
    <!--                 -->
    <xsl:variable name="VarStyleAttribute">
     <xsl:call-template name="CSS-InlineProperties">
      <xsl:with-param name="ParamProperties" select="$VarCSSProperties" />
     </xsl:call-template>
    </xsl:variable>

    <xsl:choose>
     <xsl:when test="(string-length($VarClassAttribute) &gt; 0) or (string-length($VarStyleAttribute) &gt; 0)">
      <!-- Character Style -->
      <!--                 -->
      <xsl:element name="{$VarTag}" namespace="{$GlobalDefaultNamespace}">
       <xsl:if test="string-length($VarClassAttribute) &gt; 0">
        <xsl:attribute name="class">
         <xsl:value-of select="$VarClassAttribute" />
        </xsl:attribute>
       </xsl:if>
       <xsl:if test="string-length($VarStyleAttribute) &gt; 0">
        <xsl:attribute name="style">
         <xsl:value-of select="$VarStyleAttribute" />
        </xsl:attribute>
       </xsl:if>

       <!-- Abbreviation title -->
       <!--                    -->
       <xsl:if test="string-length($VarAbbreviationTitle) &gt; 0">
        <xsl:attribute name="title">
         <xsl:value-of select="$VarAbbreviationTitle" />
        </xsl:attribute>
       </xsl:if>

       <!-- Acronym title -->
       <!--                    -->
       <xsl:if test="string-length($VarAcronymTitle) &gt; 0">
        <xsl:attribute name="title">
         <xsl:value-of select="$VarAcronymTitle" />
        </xsl:attribute>
       </xsl:if>

       <!-- Cite attribute -->
       <!--                -->
       <xsl:if test="string-length($VarCitation) &gt; 0">
        <xsl:attribute name="cite">
         <xsl:value-of select="$VarCitation" />
        </xsl:attribute>
       </xsl:if>

       <xsl:call-template name="TextRunChildren">
        <xsl:with-param name="ParamSplits" select="$ParamSplits" />
        <xsl:with-param name="ParamCargo" select="$ParamCargo" />
        <xsl:with-param name="ParamLinks" select="$ParamLinks" />
        <xsl:with-param name="ParamSplit" select="$ParamSplit" />
        <xsl:with-param name="ParamParagraphID" select="$ParamParagraphID" />
        <xsl:with-param name="ParamTextRun" select="$ParamTextRun" />
        <xsl:with-param name="ParamEmitAnchorName" select="$ParamEmitAnchorName" />
       </xsl:call-template>
      </xsl:element>
     </xsl:when>

     <xsl:otherwise>
      <!-- No style -->
      <!--          -->
      <xsl:call-template name="TextRunChildren">
       <xsl:with-param name="ParamSplits" select="$ParamSplits" />
       <xsl:with-param name="ParamCargo" select="$ParamCargo" />
       <xsl:with-param name="ParamLinks" select="$ParamLinks" />
       <xsl:with-param name="ParamSplit" select="$ParamSplit" />
       <xsl:with-param name="ParamParagraphID" select="$ParamParagraphID" />
       <xsl:with-param name="ParamTextRun" select="$ParamTextRun" />
       <xsl:with-param name="ParamEmitAnchorName" select="$ParamEmitAnchorName" />
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>

   <xsl:otherwise>
    <!-- No style -->
    <!--          -->
    <xsl:call-template name="TextRunChildren">
     <xsl:with-param name="ParamSplits" select="$ParamSplits" />
     <xsl:with-param name="ParamCargo" select="$ParamCargo" />
     <xsl:with-param name="ParamLinks" select="$ParamLinks" />
     <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     <xsl:with-param name="ParamParagraphID" select="$ParamParagraphID" />
     <xsl:with-param name="ParamTextRun" select="$ParamTextRun" />
     <xsl:with-param name="ParamEmitAnchorName" select="$ParamEmitAnchorName" />
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template name="TextRunChildren">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamParagraphID" />
  <xsl:param name="ParamTextRun" />
  <xsl:param name="ParamEmitAnchorName" />

  <!-- Force anchor on same line as containing span -->
  <!--                                              -->
  <wwexsldoc:NoBreak />

  <!-- Link? -->
  <!--       -->
  <xsl:variable name="VarLinkInfoAsXML">
   <xsl:call-template name="LinkInfo">
    <xsl:with-param name="ParamSplits" select="$ParamSplits" />
    <xsl:with-param name="ParamLinks" select="$ParamLinks" />
    <xsl:with-param name="ParamSplit" select="$ParamSplit" />
    <xsl:with-param name="ParamDocumentLink" select="$ParamTextRun/wwdoc:Link" />
   </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="VarLinkInfo" select="msxsl:node-set($VarLinkInfoAsXML)/wwlinks:LinkInfo" />

  <!-- Handle links and first textrun anchor -->
  <!--                                       -->
  <xsl:choose>
   <xsl:when test="string-length($ParamCargo/wwalinks:ALink[1]/@href) &gt; 0">
    <html:a href="{$ParamCargo/wwalinks:ALink[1]/@href}" onclick="{$ParamCargo/wwalinks:ALink[1]/@onClick}">
     <xsl:if test="string-length($VarLinkInfo/@title) &gt; 0">
      <xsl:attribute name="title">
       <xsl:value-of select="$VarLinkInfo/@title" />
      </xsl:attribute>
     </xsl:if>
     <xsl:if test="$ParamEmitAnchorName">
      <xsl:attribute name="name">
       <xsl:value-of select="$ParamParagraphID" />
      </xsl:attribute>
     </xsl:if>

     <xsl:apply-templates select="$ParamTextRun/*" mode="wwmode:textrun">
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamCargo" select="$ParamCargo" />
      <xsl:with-param name="ParamLinks" select="$ParamLinks" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     </xsl:apply-templates>
    </html:a>
   </xsl:when>

   <xsl:when test="(string-length($VarLinkInfo/@href) &gt; 0) or (string-length($VarLinkInfo/@onMouseOver) &gt; 0)">
    <html:a>
     <xsl:if test="string-length($VarLinkInfo/@href) &gt; 0">
      <xsl:attribute name="href">
       <xsl:value-of select="$VarLinkInfo/@href" />
      </xsl:attribute>
     </xsl:if>
     <xsl:if test="string-length($VarLinkInfo/@title) &gt; 0">
      <xsl:attribute name="title">
       <xsl:value-of select="$VarLinkInfo/@title" />
      </xsl:attribute>
     </xsl:if>
     <xsl:if test="string-length($VarLinkInfo/@target) &gt; 0">
      <xsl:attribute name="target">
       <xsl:value-of select="$VarLinkInfo/@target" />
      </xsl:attribute>
     </xsl:if>
     <xsl:if test="string-length($VarLinkInfo/@onMouseOver) &gt; 0">
      <xsl:attribute name="onMouseOver">
       <xsl:value-of select="$VarLinkInfo/@onMouseOver" />
      </xsl:attribute>
     </xsl:if>
     <xsl:if test="string-length($VarLinkInfo/@onMouseOut) &gt; 0">
      <xsl:attribute name="onMouseOut">
       <xsl:value-of select="$VarLinkInfo/@onMouseOut" />
      </xsl:attribute>
     </xsl:if>
     <xsl:if test="$ParamEmitAnchorName">
      <xsl:attribute name="name">
       <xsl:value-of select="$ParamParagraphID" />
      </xsl:attribute>
     </xsl:if>

     <xsl:apply-templates select="$ParamTextRun/*" mode="wwmode:textrun">
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamCargo" select="$ParamCargo" />
      <xsl:with-param name="ParamLinks" select="$ParamLinks" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     </xsl:apply-templates>
    </html:a>
   </xsl:when>

   <xsl:when test="$ParamEmitAnchorName">
    <html:a name="{$ParamParagraphID}">
     <xsl:apply-templates select="$ParamTextRun/*" mode="wwmode:textrun">
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamCargo" select="$ParamCargo" />
      <xsl:with-param name="ParamLinks" select="$ParamLinks" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     </xsl:apply-templates>
    </html:a>
   </xsl:when>

   <xsl:otherwise>
    <xsl:apply-templates select="$ParamTextRun/*" mode="wwmode:textrun">
     <xsl:with-param name="ParamSplits" select="$ParamSplits" />
     <xsl:with-param name="ParamCargo" select="$ParamCargo" />
     <xsl:with-param name="ParamLinks" select="$ParamLinks" />
     <xsl:with-param name="ParamSplit" select="$ParamSplit" />
    </xsl:apply-templates>
   </xsl:otherwise>
  </xsl:choose>

  <!-- Force anchor on same line as containing span -->
  <!--                                              -->
  <wwexsldoc:NoBreak />
 </xsl:template>


 <xsl:template match="wwdoc:Note" mode="wwmode:textrun">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />

  <xsl:variable name="VarContext" select="." />

  <!-- Implement notes -->
  <!--                 -->
  <xsl:for-each select="$ParamCargo/wwnotes:NoteNumbering[1]">
   <xsl:variable name="VarNoteNumber" select="key('wwnotes-notes-by-id', $VarContext/@id)/@number" />

   <!-- Force sup on same line as containing span -->
   <!--                                           -->
   <wwexsldoc:NoBreak />

   <html:sup>
    <!-- Force anchor on same line as containing sup -->
    <!--                                             -->
    <wwexsldoc:NoBreak />

    <html:a>
     <xsl:attribute name="name">
      <xsl:text>wwfootnote_inline_</xsl:text>
      <xsl:value-of select="$VarContext/@id" />
     </xsl:attribute>
     <xsl:attribute name="href">
      <xsl:text>#</xsl:text>
      <xsl:value-of select="$VarContext/@id" />
     </xsl:attribute>

     <xsl:value-of select="$VarNoteNumber" />
    </html:a>
   </html:sup>
  </xsl:for-each>
 </xsl:template>


 <xsl:template match="wwdoc:LineBreak" mode="wwmode:textrun">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />

  <html:br />
 </xsl:template>


 <xsl:template match="wwdoc:IndexMarker" mode="wwmode:textrun">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />

  <!-- Ignore index markers -->
  <!--                      -->
 </xsl:template>


 <xsl:template match="wwdoc:Marker" mode="wwmode:textrun">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />

  <xsl:variable name="VarMarker" select="." />

  <!-- Pass-through marker? -->
  <!--                      -->
  <xsl:for-each select="$ParamCargo/wwbehaviors:Behaviors[1]">
   <xsl:variable name="VarMarkerBehavior" select="key('wwbehaviors-markers-by-id', $VarMarker/@id)[1]" />

   <xsl:if test="$VarMarkerBehavior/@behavior = 'pass-through'">
    <!-- Pass-through -->
    <!--              -->
    <xsl:for-each select="$VarMarker/wwdoc:TextRun">
     <xsl:variable name="VarTextRun" select="." />

     <xsl:call-template name="TextRun-PassThrough">
      <xsl:with-param name="ParamTextRun" select="$VarTextRun" />
     </xsl:call-template>
    </xsl:for-each>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>


 <xsl:template match="wwdoc:Text" mode="wwmode:textrun">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />

  <xsl:value-of select="@value" />
 </xsl:template>


 <xsl:template match="wwdoc:Table" mode="wwmode:content">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamTOCData" />
  <xsl:param name="ParamSplit" />

  <xsl:variable name="VarTable" select="." />

  <!-- Aborted? -->
  <!--          -->
  <xsl:if test="not(wwprogress:Abort())">
   <xsl:variable name="VarOverrideRule" select="wwprojext:GetOverrideRule('Table', $VarTable/@stylename, $ParamSplit/@documentID, $VarTable/@id)" />
   <xsl:variable name="VarGenerateOutputOption" select="$VarOverrideRule/wwproject:Options/wwproject:Option[@Name = 'generate-output']/@Value" />
   <xsl:variable name="VarGenerateOutput" select="(string-length($VarGenerateOutputOption) = 0) or ($VarGenerateOutputOption != 'false')" />
   <xsl:if test="$VarGenerateOutput">

    <!-- Get behavior -->
    <!--              -->
    <xsl:for-each select="$ParamCargo/wwbehaviors:Behaviors[1]">
     <xsl:variable name="VarTableBehavior" select="key('wwbehaviors-tables-by-id', $VarTable/@id)[1]" />

     <!-- Table -->
     <!--       -->
     <xsl:call-template name="Table">
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamCargo" select="$ParamCargo" />
      <xsl:with-param name="ParamLinks" select="$ParamLinks" />
      <xsl:with-param name="ParamTOCData" select="$ParamTOCData" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
      <xsl:with-param name="ParamTable" select="$VarTable" />
      <xsl:with-param name="ParamStyleName" select="$VarTable/@stylename" />
      <xsl:with-param name="ParamOverrideRule" select="$VarOverrideRule" />
      <xsl:with-param name="ParamTableBehavior" select="$VarTableBehavior" />
     </xsl:call-template>
    </xsl:for-each>
   </xsl:if>
  </xsl:if>
 </xsl:template>


 <xsl:template name="Table-Attribute-In-Pixels">
  <xsl:param name="ParamValue" />

  <xsl:choose>
   <xsl:when test="string-length($ParamValue) &gt; 0">
    <!-- Normalize value for HTML attribute-->
    <!--                                   -->
    <xsl:variable name="VarValueToEmit">
     <xsl:variable name="VarUnitsSuffix" select="wwunits:UnitsSuffix($ParamValue)" />

     <xsl:choose>
      <xsl:when test="string-length($VarUnitsSuffix) &gt; 0">
       <xsl:variable name="VarNumPrefix" select="wwunits:NumericPrefix($ParamValue)" />

       <xsl:value-of select="wwunits:Convert($VarNumPrefix, $VarUnitsSuffix, 'px')" />
      </xsl:when>

      <xsl:otherwise>
       <xsl:value-of select="$ParamValue" />
      </xsl:otherwise>
     </xsl:choose>
    </xsl:variable>

    <xsl:value-of select="$VarValueToEmit" />
   </xsl:when>

   <xsl:otherwise>
    <xsl:value-of select="''" />
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template name="Table">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamTOCData" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamTable" />
  <xsl:param name="ParamStyleName" />
  <xsl:param name="ParamOverrideRule" />
  <xsl:param name="ParamTableBehavior" />

  <!-- Notes -->
  <!--       -->
  <xsl:variable name="VarNotes" select="$ParamTable//wwdoc:Note[not(ancestor::wwdoc:Frame)]" />

  <!-- Note numbering -->
  <!--                -->
  <xsl:variable name="VarNoteNumberingAsXML">
   <xsl:call-template name="Notes-Number">
    <xsl:with-param name="ParamNotes" select="$VarNotes" />
   </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="VarNoteNumbering" select="msxsl:node-set($VarNoteNumberingAsXML)" />

  <!-- Cargo for recursion -->
  <!--                     -->
  <xsl:variable name="VarCargo" select="$ParamCargo/*[local-name() != 'NoteNumbering']/.. | $VarNoteNumbering" />

  <!-- Resolve project properties -->
  <!--                            -->
  <xsl:variable name="VarResolvedPropertiesAsXML">
   <xsl:call-template name="Properties-ResolveOverrideRule">
    <xsl:with-param name="ParamProperties" select="$ParamOverrideRule/wwproject:Properties/wwproject:Property" />
    <xsl:with-param name="ParamContextStyle" select="$ParamTable/wwdoc:Style" />
   </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="VarResolvedProperties" select="msxsl:node-set($VarResolvedPropertiesAsXML)/wwproject:Property" />

  <!-- CSS properties -->
  <!--                -->
  <xsl:variable name="VarCSSPropertiesAsXML">
   <xsl:call-template name="CSS-TranslateProjectProperties">
    <xsl:with-param name="ParamProperties" select="$VarResolvedProperties" />
    <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
    <xsl:with-param name="ParamSplits" select="$ParamSplits" />
   </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="VarCSSProperties" select="msxsl:node-set($VarCSSPropertiesAsXML)/wwproject:Property" />

  <xsl:variable name="VarContextRule" select="wwprojext:GetContextRule('Table', $ParamTable/@stylename, $ParamSplit/@documentID, $ParamTable/@id)" />

  <!-- Resolve project properties -->
  <!--                            -->
  <xsl:variable name="VarResolvedContextPropertiesAsXML">
   <xsl:call-template name="Properties-ResolveContextRule">
    <xsl:with-param name="ParamDocumentContext" select="$ParamTable" />
    <xsl:with-param name="ParamProperties" select="$VarContextRule/wwproject:Properties/wwproject:Property" />
    <xsl:with-param name="ParamStyleName" select="$ParamTable/@stylename" />
    <xsl:with-param name="ParamStyleType" select="'Table'" />
    <xsl:with-param name="ParamContextStyle" select="$ParamTable/wwdoc:Style" />
   </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="VarResolvedContextProperties" select="msxsl:node-set($VarResolvedContextPropertiesAsXML)/wwproject:Property" />

  <!-- Table class -->
  <!--             -->
  <xsl:variable name="VarClassAttribute">
   <xsl:value-of select="wwstring:CSSClassName($ParamStyleName)" />

   <!-- Additional CSS classes -->
   <!--                        -->
   <xsl:variable name="VarAdditionalCSSClassesOption" select="normalize-space($VarContextRule/wwproject:Options/wwproject:Option[@Name = 'additional-css-classes']/@Value)" />
   <xsl:if test="string-length($VarAdditionalCSSClassesOption) &gt; 0">
    <xsl:text> </xsl:text>
    <xsl:value-of select="$VarAdditionalCSSClassesOption" />
   </xsl:if>
  </xsl:variable>

  <!-- Style attribute -->
  <!--                 -->
  <xsl:variable name="VarStyleAttribute">
   <xsl:call-template name="CSS-InlineProperties">
    <xsl:with-param name="ParamProperties" select="$VarCSSProperties[(@Name != 'vertical-align')]" />
   </xsl:call-template>
  </xsl:variable>

  <!-- Border -->
  <!--        -->
  <xsl:variable name="VarTableBorder">
   <xsl:call-template name="Table-Attribute-In-Pixels">
    <xsl:with-param name="ParamValue" select="$VarResolvedContextProperties[@Name = 'border']/@Value" />
   </xsl:call-template>
  </xsl:variable>

  <!-- Cell padding -->
  <!--              -->
  <xsl:variable name="VarTableCellPadding">
   <xsl:call-template name="Table-Attribute-In-Pixels">
    <xsl:with-param name="ParamValue" select="$VarResolvedContextProperties[@Name = 'cell-padding']/@Value" />
   </xsl:call-template>
  </xsl:variable>

  <!-- Cell spacing -->
  <!--              -->
  <xsl:variable name="VarTableCellSpacing">
   <xsl:call-template name="Table-Attribute-In-Pixels">
    <xsl:with-param name="ParamValue" select="$VarResolvedContextProperties[@Name = 'cell-spacing']/@Value" />
   </xsl:call-template>
  </xsl:variable>

  <!-- Table vertical alignment -->
  <!--                          -->
  <xsl:variable name="VarTableVerticalAlignment">
   <xsl:variable name="VarTableVerticalAlignmentHint" select="$VarResolvedContextProperties[@Name = 'vertical-align']/@Value" />
   <xsl:choose>
    <xsl:when test="string-length($VarTableVerticalAlignmentHint) &gt; 0">
     <xsl:value-of select="$VarTableVerticalAlignmentHint" />
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="''" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

  <!-- Table summary -->
  <!--               -->
  <xsl:variable name="VarTableSummary">
   <xsl:call-template name="Tables-Summary">
    <xsl:with-param name="ParamTableBehavior" select="$ParamTableBehavior" />
   </xsl:call-template>
  </xsl:variable>

  <!-- Caption Side -->
  <!--              -->
  <xsl:variable name="VarCaptionSide">
   <xsl:value-of select="$VarResolvedContextProperties[@Name = 'caption-side']/@Value" />
  </xsl:variable>

  <!-- Determine table cell widths -->
  <!--                             -->
  <xsl:variable name="VarTableCellWidthsAsXML">
   <xsl:variable name="VarEmitTableWidthsOption" select="$VarContextRule/wwproject:Options/wwproject:Option[@Name = 'table-use-document-cell-widths']/@Value" />
   <xsl:variable name="VarEmitTableWidths" select="$VarEmitTableWidthsOption = 'true'" />
   <xsl:variable name="VarUsePercentageWidthsOption" select="$VarContextRule/wwproject:Options/wwproject:Option[@Name = 'table-use-percentage-cell-widths']/@Value" />
   <xsl:variable name="VarUsePercentageWidths" select="$VarUsePercentageWidthsOption = 'true'" />

   <xsl:if test="$VarEmitTableWidths">
    <!-- Use percentage cell widths? -->
    <!--                             -->
    <xsl:choose>
     <!-- Use percentage cell widths -->
     <!--                            -->
     <xsl:when test="$VarUsePercentageWidths">
      <xsl:call-template name="Table-CellWidthsAsPercentage">
       <xsl:with-param name="ParamTable" select="$ParamTable" />
       <xsl:with-param name="ParamReportAllCellWidths" select="false()" />
      </xsl:call-template>
     </xsl:when>

     <!-- Use original cell widths -->
     <!--                          -->
     <xsl:otherwise>
      <xsl:call-template name="Table-CellWidths">
       <xsl:with-param name="ParamTable" select="$ParamTable" />
       <xsl:with-param name="ParamReportAllCellWidths" select="false()" />
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
  </xsl:variable>
  <xsl:variable name="VarTableCellWidths" select="msxsl:node-set($VarTableCellWidthsAsXML)/*" />

  <!-- Emit <table> element with class, style, and summary attrs. -->
  <!--                                                                -->
  <html:table class="{$VarClassAttribute}">

   <!-- style attribute -->
   <!--                 -->
   <xsl:if test="string-length($VarStyleAttribute) &gt; 0">
    <xsl:attribute name="style">
     <xsl:value-of select="$VarStyleAttribute" />
    </xsl:attribute>
   </xsl:if>

   <!-- border attribute -->
   <!--                  -->
   <xsl:if test="string-length($VarTableBorder) &gt; 0">
    <xsl:attribute name="border">
     <xsl:value-of select="$VarTableBorder" />
    </xsl:attribute>
   </xsl:if>

   <!-- cellpadding attribute -->
   <!--                       -->
   <xsl:if test="string-length($VarTableCellPadding) &gt; 0">
    <xsl:attribute name="cellpadding">
     <xsl:value-of select="$VarTableCellPadding" />
    </xsl:attribute>
   </xsl:if>

   <!-- cellspacing attribute -->
   <!--                       -->
   <xsl:if test="string-length($VarTableCellSpacing) &gt; 0">
    <xsl:attribute name="cellspacing">
     <xsl:value-of select="$VarTableCellSpacing" />
    </xsl:attribute>
   </xsl:if>

   <!-- summary attribute -->
   <!--                   -->
   <xsl:attribute name="summary">
    <xsl:value-of select="$VarTableSummary" />
   </xsl:attribute>

   <!-- Apply caption templates -->
   <!--                         -->
   <xsl:for-each select="$ParamTable/wwdoc:Caption[1]">
    <html:caption>

     <xsl:if test="string-length($VarCaptionSide) &gt; 0">
      <xsl:attribute name="style">
       <xsl:value-of select="concat('caption-side: ', $VarCaptionSide)" />
      </xsl:attribute>
     </xsl:if>

     <xsl:apply-templates select="./*" mode="wwmode:content">
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamCargo" select="$ParamCargo" />
      <xsl:with-param name="ParamLinks" select="$ParamLinks" />
      <xsl:with-param name="ParamTOCData" select="$ParamTOCData" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     </xsl:apply-templates>

    </html:caption>
   </xsl:for-each>

   <xsl:for-each select="$ParamTable/wwdoc:TableHead|$ParamTable/wwdoc:TableBody|$ParamTable/wwdoc:TableFoot">
    <xsl:variable name="VarSection" select="." />

    <!-- Resolve section properties -->
    <!--                            -->
    <xsl:variable name="VarResolvedSectionPropertiesAsXML">
     <xsl:call-template name="Properties-Table-Section-ResolveContextRule">
      <xsl:with-param name="ParamProperties" select="$VarContextRule/wwproject:Properties/wwproject:Property" />
      <xsl:with-param name="ParamDocumentContext" select="$ParamTable" />
      <xsl:with-param name="ParamTable" select="$ParamTable" />
      <xsl:with-param name="ParamSection" select="$VarSection" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarResolvedSectionProperties" select="msxsl:node-set($VarResolvedSectionPropertiesAsXML)/wwproject:Property" />

    <!-- Process section rows -->
    <!--                      -->
    <xsl:for-each select="$VarSection/wwdoc:TableRow">
     <xsl:variable name="VarTableRow" select="." />
     <xsl:variable name="VarRowPosition" select="position()" />

     <html:tr>

      <!-- Handle table level vertical align at row level -->
      <!--                                                -->
      <xsl:if test="string-length($VarTableVerticalAlignment) &gt; 0">
       <xsl:attribute name="style">
        <xsl:value-of select="concat('vertical-align: ', $VarTableVerticalAlignment, ';')" />
       </xsl:attribute>
      </xsl:if>

      <xsl:for-each select="$VarTableRow/wwdoc:TableCell">
       <xsl:variable name="VarTableCell" select="." />
       <xsl:variable name="VarCellPosition" select="position()" />

       <!-- Resolve cell properties -->
       <!--                         -->
       <xsl:variable name="VarResolvedCellPropertiesAsXML">
        <xsl:call-template name="Properties-Table-Cell-ResolveProperties">
         <xsl:with-param name="ParamSectionProperties" select="$VarResolvedSectionProperties" />
         <xsl:with-param name="ParamCellStyle" select="$VarTableCell/wwdoc:Style" />
         <xsl:with-param name="ParamRowIndex" select="$VarRowPosition" />
         <xsl:with-param name="ParamColumnIndex" select="$VarCellPosition" />
        </xsl:call-template>

        <!-- Width attribute -->
        <!--                 -->
        <xsl:for-each select="$VarTableCellWidths[@id = $VarTableCell/@id][1]">
         <xsl:variable name="VarTableCellWidth" select="." />

         <wwproject:Property Name="width" Value="{$VarTableCellWidth/@width}" />
        </xsl:for-each>
       </xsl:variable>
       <xsl:variable name="VarResolvedCellProperties" select="msxsl:node-set($VarResolvedCellPropertiesAsXML)/wwproject:Property" />

       <!-- Valid CSS properties -->
       <!--                      -->
       <xsl:variable name="VarTableCellCSSPropertiesAsXML">
        <xsl:call-template name="CSS-TranslateProjectProperties">
         <xsl:with-param name="ParamProperties" select="$VarResolvedCellProperties" />
         <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
         <xsl:with-param name="ParamSplits" select="$ParamSplits" />
        </xsl:call-template>
       </xsl:variable>
       <xsl:variable name="VarTableCellCSSProperties" select="msxsl:node-set($VarTableCellCSSPropertiesAsXML)/wwproject:Property" />

       <!-- Inline CSS properties -->
       <!--                       -->
       <xsl:variable name="VarInlineCSSProperties">
        <xsl:call-template name="CSS-InlineProperties">
         <xsl:with-param name="ParamProperties" select="$VarTableCellCSSProperties" />
        </xsl:call-template>
       </xsl:variable>

       <!-- Calculate row span -->
       <!--                    -->
       <xsl:variable name="VarRowSpan">
        <xsl:variable name="VarRowSpanHint" select="$VarTableCell/wwdoc:Style/wwdoc:Attribute[@name = 'row-span']/@value" />
        <xsl:choose>
         <xsl:when test="string-length($VarRowSpanHint) &gt; 0">
          <xsl:value-of select="$VarRowSpanHint" />
         </xsl:when>
         <xsl:otherwise>
          <xsl:value-of select="'0'" />
         </xsl:otherwise>
        </xsl:choose>
       </xsl:variable>

       <!-- Calculate column span -->
       <!--                       -->
       <xsl:variable name="VarColumnSpan">
        <xsl:variable name="VarColumnSpanHint" select="$VarTableCell/wwdoc:Style/wwdoc:Attribute[@name = 'column-span']/@value" />
        <xsl:choose>
         <xsl:when test="string-length($VarColumnSpanHint) &gt; 0">
          <xsl:value-of select="$VarColumnSpanHint" />
         </xsl:when>
         <xsl:otherwise>
          <xsl:value-of select="'0'" />
         </xsl:otherwise>
        </xsl:choose>
       </xsl:variable>

       <!-- Emit cell -->
       <!--           -->
       <html:td>
        <!-- Style attribute -->
        <!--                 -->
        <xsl:if test="string-length($VarInlineCSSProperties) &gt; 0">
         <xsl:attribute name="style">
          <xsl:value-of select="$VarInlineCSSProperties" />
         </xsl:attribute>
        </xsl:if>

        <!-- Row span attribute -->
        <!--                    -->
        <xsl:if test="number($VarRowSpan) &gt; 0">
         <xsl:attribute name="rowspan">
          <xsl:value-of select="$VarRowSpan" />
         </xsl:attribute>
        </xsl:if>

        <!-- Column span attribute -->
        <!--                       -->
        <xsl:if test="number($VarColumnSpan) &gt; 0">
         <xsl:attribute name="colspan">
          <xsl:value-of select="$VarColumnSpan" />
         </xsl:attribute>
        </xsl:if>

        <!-- Recurse -->
        <!--         -->
        <xsl:apply-templates select="./*" mode="wwmode:content">
         <xsl:with-param name="ParamSplits" select="$ParamSplits" />
         <xsl:with-param name="ParamCargo" select="$VarCargo" />
         <xsl:with-param name="ParamLinks" select="$ParamLinks" />
         <xsl:with-param name="ParamTOCData" select="$ParamTOCData" />
         <xsl:with-param name="ParamSplit" select="$ParamSplit" />
        </xsl:apply-templates>
       </html:td>
      </xsl:for-each>

     </html:tr>
    </xsl:for-each>
   </xsl:for-each>

  </html:table>

  <!-- Table Footnotes -->
  <!--                 -->
  <xsl:call-template name="Content-Notes">
   <xsl:with-param name="ParamNotes" select="$VarNotes" />
   <xsl:with-param name="ParamSplits" select="$ParamSplits" />
   <xsl:with-param name="ParamCargo" select="$VarCargo" />
   <xsl:with-param name="ParamLinks" select="$ParamLinks" />
   <xsl:with-param name="ParamTOCData" select="$ParamTOCData" />
   <xsl:with-param name="ParamSplit" select="$ParamSplit" />
  </xsl:call-template>

  <!-- Dropdown End -->
  <!--              -->
  <xsl:if test="$ParamTableBehavior/@dropdown = 'end'">
   <html:script type="text/javascript" language="JavaScript1.2">WebWorks_WriteDIVClose();</html:script>
  </xsl:if>
 </xsl:template>


 <xsl:template match="wwdoc:Frame" mode="wwmode:content">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamTOCData" />
  <xsl:param name="ParamSplit" />

  <!-- Aborted? -->
  <!--          -->
  <xsl:if test="not(wwprogress:Abort())">
   <xsl:call-template name="Frame">
    <xsl:with-param name="ParamFrame" select="." />
    <xsl:with-param name="ParamSplits" select="$ParamSplits" />
    <xsl:with-param name="ParamCargo" select="$ParamCargo" />
    <xsl:with-param name="ParamLinks" select="$ParamLinks" />
    <xsl:with-param name="ParamSplit" select="$ParamSplit" />
   </xsl:call-template>
  </xsl:if>
 </xsl:template>


 <xsl:template match="wwdoc:Frame" mode="wwmode:textrun">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />

  <xsl:call-template name="Frame">
   <xsl:with-param name="ParamFrame" select="." />
   <xsl:with-param name="ParamSplits" select="$ParamSplits" />
   <xsl:with-param name="ParamCargo" select="$ParamCargo" />
   <xsl:with-param name="ParamLinks" select="$ParamLinks" />
   <xsl:with-param name="ParamSplit" select="$ParamSplit" />
  </xsl:call-template>
 </xsl:template>


 <xsl:template name="Frame">
  <xsl:param name="ParamFrame" />
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />

  <!-- Get splits frame -->
  <!--                  -->
  <xsl:for-each select="$ParamSplits[1]">
   <xsl:variable name="VarSplitsFrame" select="key('wwsplits-frames-by-id', $ParamFrame/@id)[@documentID = $ParamSplit/@documentID]" />

   <!-- Frame known? -->
   <!--              -->
   <xsl:if test="count($VarSplitsFrame) = 1">
    <!-- Thumbnail? -->
    <!--            -->
    <xsl:for-each select="$GlobalFiles[1]">
     <xsl:variable name="VarSplitsThumbnail" select="$VarSplitsFrame/wwsplits:Thumbnail" />
     <xsl:variable name="VarThumbnailDefined" select="count(key('wwfiles-files-by-path', $VarSplitsThumbnail/@path)[1]) &gt; 0" />

     <!-- Emit image -->
     <!--            -->
     <xsl:choose>
      <!-- Thumbnail -->
      <!--           -->
      <xsl:when test="$VarThumbnailDefined">
       <!-- Emit markup -->
       <!--             -->
       <xsl:call-template name="Frame-Markup">
        <xsl:with-param name="ParamFrame" select="$ParamFrame" />
        <xsl:with-param name="ParamSplits" select="$ParamSplits" />
        <xsl:with-param name="ParamCargo" select="$ParamCargo" />
        <xsl:with-param name="ParamLinks" select="$ParamLinks" />
        <xsl:with-param name="ParamSplit" select="$ParamSplit" />
        <xsl:with-param name="ParamSplitsFrame" select="$VarSplitsFrame" />
        <xsl:with-param name="ParamThumbnail" select="true()" />
       </xsl:call-template>
      </xsl:when>

      <!-- Fullsize -->
      <!--          -->
      <xsl:otherwise>
       <!-- Note numbering -->
       <!--                -->
       <xsl:variable name="VarNotes" select="$ParamFrame//wwdoc:Note" />
       <xsl:variable name="VarNoteNumberingAsXML">
        <xsl:call-template name="Notes-Number">
         <xsl:with-param name="ParamNotes" select="$VarNotes" />
        </xsl:call-template>
       </xsl:variable>
       <xsl:variable name="VarNoteNumbering" select="msxsl:node-set($VarNoteNumberingAsXML)" />

       <!-- Frame cargo -->
       <!--             -->
       <xsl:variable name="VarCargo" select="$ParamCargo/*[local-name() != 'NoteNumbering']/.. | $VarNoteNumbering" />

       <!-- Emit markup -->
       <!--             -->
       <xsl:call-template name="Frame-Markup">
        <xsl:with-param name="ParamFrame" select="$ParamFrame" />
        <xsl:with-param name="ParamSplits" select="$ParamSplits" />
        <xsl:with-param name="ParamCargo" select="$VarCargo" />
        <xsl:with-param name="ParamLinks" select="$ParamLinks" />
        <xsl:with-param name="ParamSplit" select="$ParamSplit" />
        <xsl:with-param name="ParamSplitsFrame" select="$VarSplitsFrame" />
        <xsl:with-param name="ParamThumbnail" select="false()" />
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:for-each>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Frame-Markup">
  <xsl:param name="ParamFrame" />
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamSplitsFrame" />
  <xsl:param name="ParamThumbnail" />

  <!-- Context Rule -->
  <!--              -->
  <xsl:variable name="VarContextRule" select="wwprojext:GetContextRule('Graphic', $ParamSplitsFrame/@stylename, $ParamSplitsFrame/@documentID, $ParamSplitsFrame/@id)" />

  <!-- Generate? -->
  <!--           -->
  <xsl:variable name="VarGenerateOutputOption" select="$VarContextRule/wwproject:Options/wwproject:Option[@Name = 'generate-output']/@Value" />
  <xsl:variable name="VarGenerateOutput" select="(string-length($VarGenerateOutputOption) = 0) or ($VarGenerateOutputOption != 'false')" />
  <xsl:if test="$VarGenerateOutput">
   <!-- Determine image path -->
   <!--                      -->
   <xsl:variable name="VarImagePath">
    <xsl:choose>
     <xsl:when test="$ParamThumbnail">
      <xsl:value-of select="$ParamSplitsFrame/wwsplits:Thumbnail/@path" />
     </xsl:when>

     <xsl:otherwise>
      <xsl:value-of select="$ParamSplitsFrame/@path" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <!-- Access image info -->
   <!--                   -->
   <xsl:variable name="VarImageInfo" select="wwimaging:GetInfo($VarImagePath)" />

   <!-- Determine type -->
   <!--                -->
   <xsl:variable name="VarVectorImageAsText">
    <xsl:call-template name="Images-VectorImageFormat">
     <xsl:with-param name="ParamImageInfo" select="$VarImageInfo" />
    </xsl:call-template>
   </xsl:variable>
   <xsl:variable name="VarVectorImage" select="$VarVectorImageAsText = string(true())" />
   <xsl:variable name="VarRasterImageAsText">
    <xsl:call-template name="Images-RasterImageFormat">
     <xsl:with-param name="ParamImageInfo" select="$VarImageInfo" />
    </xsl:call-template>
   </xsl:variable>
   <xsl:variable name="VarRasterImage" select="$VarRasterImageAsText = string(true())" />

   <!-- Emit image -->
   <!--            -->
   <xsl:choose>
    <!-- Vector Image -->
    <!--              -->
    <xsl:when test="$VarVectorImage">
     <xsl:call-template name="Frame-Markup-Vector">
      <xsl:with-param name="ParamFrame" select="$ParamFrame" />
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamCargo" select="$ParamCargo" />
      <xsl:with-param name="ParamLinks" select="$ParamLinks" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
      <xsl:with-param name="ParamSplitsFrame" select="$ParamSplitsFrame" />
      <xsl:with-param name="ParamContextRule" select="$VarContextRule" />
      <xsl:with-param name="ParamImageInfo" select="$VarImageInfo" />
      <xsl:with-param name="ParamThumbnail" select="$ParamThumbnail" />
     </xsl:call-template>
    </xsl:when>

    <!-- Raster Image -->
    <!--              -->
    <xsl:when test="$VarRasterImage">
     <xsl:call-template name="Frame-Markup-Raster">
      <xsl:with-param name="ParamFrame" select="$ParamFrame" />
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamCargo" select="$ParamCargo" />
      <xsl:with-param name="ParamLinks" select="$ParamLinks" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
      <xsl:with-param name="ParamSplitsFrame" select="$ParamSplitsFrame" />
      <xsl:with-param name="ParamContextRule" select="$VarContextRule" />
      <xsl:with-param name="ParamImageInfo" select="$VarImageInfo" />
      <xsl:with-param name="ParamThumbnail" select="$ParamThumbnail" />
     </xsl:call-template>
    </xsl:when>
   </xsl:choose>
  </xsl:if>
 </xsl:template>


 <xsl:template name="Frame-Markup-Vector">
  <xsl:param name="ParamFrame" />
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamSplitsFrame" />
  <xsl:param name="ParamContextRule" />
  <xsl:param name="ParamImageInfo" />
  <xsl:param name="ParamThumbnail" />

  <xsl:choose>
   <!-- SVG -->
   <!--     -->
   <xsl:when test="$ParamImageInfo/@format = 'svg'">
    <xsl:call-template name="Frame-Markup-Vector-SVG">
     <xsl:with-param name="ParamFrame" select="$ParamFrame" />
     <xsl:with-param name="ParamSplits" select="$ParamSplits" />
     <xsl:with-param name="ParamCargo" select="$ParamCargo" />
     <xsl:with-param name="ParamLinks" select="$ParamLinks" />
     <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     <xsl:with-param name="ParamSplitsFrame" select="$ParamSplitsFrame" />
     <xsl:with-param name="ParamContextRule" select="$ParamContextRule" />
     <xsl:with-param name="ParamImageInfo" select="$ParamImageInfo" />
     <xsl:with-param name="ParamThumbnail" select="$ParamThumbnail" />
    </xsl:call-template>
   </xsl:when>
  </xsl:choose>
 </xsl:template>


 <xsl:template name="Frame-Markup-Vector-SVG">
  <xsl:param name="ParamFrame" />
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamSplitsFrame" />
  <xsl:param name="ParamContextRule" />
  <xsl:param name="ParamImageInfo" />
  <xsl:param name="ParamThumbnail" />

  <!-- Access frame behavior -->
  <!--                       -->
  <xsl:for-each select="$ParamCargo/wwbehaviors:Behaviors[1]">
   <xsl:variable name="VarBehaviorFrame" select="key('wwbehaviors-frames-by-id', $ParamFrame/@id)[1]" />

   <!-- Resolve project properties -->
   <!--                            -->
   <xsl:variable name="VarResolvedPropertiesAsXML">
    <xsl:call-template name="Properties-ResolveContextRule">
     <xsl:with-param name="ParamDocumentContext" select="$ParamFrame" />
     <xsl:with-param name="ParamProperties" select="$ParamContextRule/wwproject:Properties/wwproject:Property" />
     <xsl:with-param name="ParamStyleName" select="$ParamFrame/@stylename" />
     <xsl:with-param name="ParamStyleType" select="'Graphic'" />
     <xsl:with-param name="ParamContextStyle" select="$ParamFrame" />
    </xsl:call-template>
   </xsl:variable>
   <xsl:variable name="VarResolvedProperties" select="msxsl:node-set($VarResolvedPropertiesAsXML)/wwproject:Property" />

   <!-- CSS properties -->
   <!--                -->
   <xsl:variable name="VarCSSPropertiesAsXML">
    <xsl:call-template name="CSS-TranslateProjectProperties">
     <xsl:with-param name="ParamProperties" select="$VarResolvedProperties[(@Name != 'width') and (@Name != 'height')]" />
     <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
     <xsl:with-param name="ParamSplits" select="$ParamSplits" />
    </xsl:call-template>
   </xsl:variable>
   <xsl:variable name="VarCSSProperties" select="msxsl:node-set($VarCSSPropertiesAsXML)/wwproject:Property" />
   <xsl:variable name="VarInlineCSSProperties">
    <xsl:call-template name="CSS-InlineProperties">
     <xsl:with-param name="ParamProperties" select="$VarCSSProperties[string-length(@Value) &gt; 0]" />
    </xsl:call-template>
   </xsl:variable>

   <!-- Width/Height -->
   <!--              -->
   <xsl:variable name="VarByReferenceGraphicsUseDocumentDimensionsOption" select="$ParamContextRule/wwproject:Options/wwproject:Option[@Name = 'by-reference-use-document-dimensions']/@Value" />
   <xsl:variable name="VarByReferenceGraphicsUseDocumentDimensions" select="(string-length($VarByReferenceGraphicsUseDocumentDimensionsOption) = 0) or ($VarByReferenceGraphicsUseDocumentDimensionsOption = 'true')" />
   <xsl:variable name="VarWidth">
    <xsl:choose>
     <xsl:when test="count($VarResolvedProperties[@Name = 'width']) = 0">
      <xsl:value-of select="0" />
     </xsl:when>

     <xsl:when test="$ParamThumbnail">
      <xsl:value-of select="number($ParamImageInfo/@width)" />
     </xsl:when>

     <xsl:when test="$ParamSplitsFrame/@byref = 'true'">
      <xsl:choose>
       <xsl:when test="($VarByReferenceGraphicsUseDocumentDimensions) or (number($ParamImageInfo/@width) = 0)">
        <xsl:variable name="VarByReferenceFrame" select="$ParamFrame//wwdoc:Facet[@type = 'by-reference'][1]/../.." />

        <xsl:value-of select="floor(wwunits:Convert(wwunits:NumericPrefix($VarByReferenceFrame/wwdoc:Attribute[@name = 'width']/@value), 'pt', 'px'))" />
       </xsl:when>

       <xsl:otherwise>
        <xsl:value-of select="number($ParamImageInfo/@width)" />
       </xsl:otherwise>
      </xsl:choose>
     </xsl:when>

     <xsl:otherwise>
      <xsl:value-of select="number($ParamImageInfo/@width)" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>
   <xsl:variable name="VarHeight">
    <xsl:choose>
     <xsl:when test="count($VarResolvedProperties[@Name = 'height']) = 0">
      <xsl:value-of select="0" />
     </xsl:when>

     <xsl:when test="$ParamThumbnail">
      <xsl:value-of select="number($ParamImageInfo/@height)" />
     </xsl:when>

     <xsl:when test="$ParamSplitsFrame/@byref = 'true'">
      <xsl:choose>
       <xsl:when test="($VarByReferenceGraphicsUseDocumentDimensions) or (number($ParamImageInfo/@height) = 0)">
        <xsl:variable name="VarByReferenceFrame" select="$ParamFrame//wwdoc:Facet[@type = 'by-reference'][1]/../.." />

        <xsl:value-of select="floor(wwunits:Convert(wwunits:NumericPrefix($VarByReferenceFrame/wwdoc:Attribute[@name = 'height']/@value), 'pt', 'px'))" />
       </xsl:when>

       <xsl:otherwise>
        <xsl:value-of select="number($ParamImageInfo/@height)" />
       </xsl:otherwise>
      </xsl:choose>
     </xsl:when>

     <xsl:otherwise>
      <xsl:value-of select="number($ParamImageInfo/@height)" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <!-- Src -->
   <!--     -->
   <xsl:variable name="VarSrc" select="wwuri:GetRelativeTo($ParamImageInfo/@path, $ParamSplit/@path)" />

   <!-- Alt Text -->
   <!--          -->
   <xsl:variable name="VarAltText">
    <xsl:call-template name="Images-AltText">
     <xsl:with-param name="ParamFrame" select="$ParamFrame" />
     <xsl:with-param name="ParamBehaviorFrame" select="$VarBehaviorFrame" />
    </xsl:call-template>
   </xsl:variable>

   <!-- Long Description -->
   <!--                  -->
   <xsl:variable name="VarLongDescription">
    <xsl:call-template name="Images-LongDescription">
     <xsl:with-param name="ParamSplitsFrame" select="$ParamSplitsFrame" />
     <xsl:with-param name="ParamBehaviorFrame" select="$VarBehaviorFrame" />
    </xsl:call-template>
   </xsl:variable>

   <!-- SVG object tag info:                                          -->
   <!--   http://joliclic.free.fr/html/object-tag/en/object-svg.html  -->
   <!--   http://volity.org/wiki/index.cgi?SVG_Scaling                -->
   <!--                                                               -->

   <!-- Graphic element -->
   <!--                 -->
   <html:object>
    <!-- Type attribute -->
    <!--                -->
    <xsl:attribute name="type">
     <xsl:text>image/svg+xml</xsl:text>
    </xsl:attribute>

    <!-- Data attribute -->
    <!--                -->
    <xsl:attribute name="data">
     <xsl:value-of select="$VarSrc" />
    </xsl:attribute>

    <!-- Width attribute -->
    <!--                 -->
    <xsl:if test="$VarWidth &gt; 0">
     <xsl:attribute name="width">
      <xsl:value-of select="$VarWidth"/>
     </xsl:attribute>
    </xsl:if>

    <!-- Height attribute -->
    <!--                  -->
    <xsl:if test="$VarHeight &gt; 0">
     <xsl:attribute name="height">
      <xsl:value-of select="$VarHeight"/>
     </xsl:attribute>
    </xsl:if>

    <!-- Style attribute -->
    <!--                 -->
    <xsl:if test="string-length($VarInlineCSSProperties) &gt; 0">
     <xsl:attribute name="style">
      <xsl:value-of select="$VarInlineCSSProperties" />
     </xsl:attribute>
    </xsl:if>

    <!-- Title attribute -->
    <!--                 -->
    <xsl:choose>
     <xsl:when test="string-length($VarAltText) &gt; 0">
      <xsl:attribute name="title">
       <xsl:value-of select="$VarAltText" />
      </xsl:attribute>
     </xsl:when>

     <xsl:when test="string-length($ParamSplitsFrame/@title) &gt; 0">
      <xsl:attribute name="title">
       <xsl:value-of select="$ParamSplitsFrame/@title" />
      </xsl:attribute>
     </xsl:when>
    </xsl:choose>

    <!-- Src parameter -->
    <!--               -->
    <html:param name="src" value="{$VarSrc}" valuetype="data" />
   </html:object>

   <!-- Generate D Links -->
   <!--                  -->
   <xsl:variable name="VarGenerateDLinks" select="wwprojext:GetFormatSetting('accessibility-image-d-links', 'false')" />
   <xsl:if test="$VarGenerateDLinks = 'true'">
    <xsl:if test="string-length($VarLongDescription) &gt; 0">
     <xsl:text> </xsl:text>
     <html:a href="{$VarLongDescription}" title="{concat('Description link for ', wwfilesystem:GetFileName($ParamSplitsFrame/@path))}">[D]</html:a><html:br />
    </xsl:if>
   </xsl:if>

   <!-- Notes -->
   <!--       -->
   <xsl:choose>
    <!-- Thumbnail -->
    <!--           -->
    <xsl:when test="$ParamThumbnail">
     <!-- Nothing to do -->
     <!--               -->
    </xsl:when>

    <!-- Fullsize -->
    <!--          -->
    <xsl:otherwise>
     <!-- Frame Footnotes -->
     <!--                 -->
     <xsl:variable name="VarNotes" select="$ParamFrame//wwdoc:Note" />
     <xsl:call-template name="Content-Notes">
      <xsl:with-param name="ParamNotes" select="$VarNotes" />
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamCargo" select="$ParamCargo" />
      <xsl:with-param name="ParamLinks" select="$ParamLinks" />
      <xsl:with-param name="ParamTOCData" select="''" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Frame-Markup-Raster">
  <xsl:param name="ParamFrame" />
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamSplitsFrame" />
  <xsl:param name="ParamContextRule" />
  <xsl:param name="ParamImageInfo" />
  <xsl:param name="ParamThumbnail" />

  <!-- Access frame behavior -->
  <!--                       -->
  <xsl:for-each select="$ParamCargo/wwbehaviors:Behaviors[1]">
   <xsl:variable name="VarBehaviorFrame" select="key('wwbehaviors-frames-by-id', $ParamFrame/@id)[1]" />

   <!-- Override Rule -->
   <!--               -->
   <xsl:variable name="VarOverrideRule" select="wwprojext:GetOverrideRule('Graphic', $ParamSplitsFrame/@stylename, $ParamSplitsFrame/@documentID, $ParamSplitsFrame/@id)" />

   <!-- Resolve project properties -->
   <!--                            -->
   <xsl:variable name="VarResolvedPropertiesAsXML">
    <xsl:call-template name="Properties-ResolveOverrideRule">
     <xsl:with-param name="ParamProperties" select="$VarOverrideRule/wwproject:Properties/wwproject:Property" />
     <xsl:with-param name="ParamContextStyle" select="$ParamFrame" />
     <xsl:with-param name="ParamStyleType" select="'Graphic'" />
    </xsl:call-template>
   </xsl:variable>
   <xsl:variable name="VarResolvedProperties" select="msxsl:node-set($VarResolvedPropertiesAsXML)/wwproject:Property" />

   <!-- CSS properties -->
   <!--                -->
   <xsl:variable name="VarCSSPropertiesAsXML">
    <xsl:call-template name="CSS-TranslateProjectProperties">
     <xsl:with-param name="ParamProperties" select="$VarResolvedProperties[(@Name != 'width') and (@Name != 'height')]" />
     <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
     <xsl:with-param name="ParamSplits" select="$ParamSplits" />
    </xsl:call-template>
   </xsl:variable>
   <xsl:variable name="VarCSSProperties" select="msxsl:node-set($VarCSSPropertiesAsXML)/wwproject:Property" />
   <xsl:variable name="VarInlineCSSProperties">
    <xsl:call-template name="CSS-InlineProperties">
     <xsl:with-param name="ParamProperties" select="$VarCSSProperties[string-length(@Value) &gt; 0]" />
    </xsl:call-template>
   </xsl:variable>

   <!-- Width/Height -->
   <!--              -->
   <xsl:variable name="VarByReferenceGraphicsUseDocumentDimensionsOption" select="$ParamContextRule/wwproject:Options/wwproject:Option[@Name = 'by-reference-use-document-dimensions']/@Value" />
   <xsl:variable name="VarByReferenceGraphicsUseDocumentDimensions" select="(string-length($VarByReferenceGraphicsUseDocumentDimensionsOption) = 0) or ($VarByReferenceGraphicsUseDocumentDimensionsOption = 'true')" />
   <xsl:variable name="VarWidth">
    <xsl:choose>
     <xsl:when test="count($VarResolvedProperties[@Name = 'width']) = 0">
      <xsl:value-of select="0" />
     </xsl:when>

     <xsl:when test="$ParamThumbnail">
      <xsl:value-of select="number($ParamImageInfo/@width)" />
     </xsl:when>

     <xsl:when test="$ParamSplitsFrame/@byref = 'true'">
      <xsl:choose>
       <xsl:when test="$VarByReferenceGraphicsUseDocumentDimensions">
        <xsl:variable name="VarByReferenceFrame" select="$ParamFrame//wwdoc:Facet[@type = 'by-reference'][1]/../.." />

        <xsl:value-of select="floor(wwunits:Convert(wwunits:NumericPrefix($VarByReferenceFrame/wwdoc:Attribute[@name = 'width']/@value), 'pt', 'px'))" />
       </xsl:when>

       <xsl:otherwise>
        <xsl:value-of select="number($ParamImageInfo/@width)" />
       </xsl:otherwise>
      </xsl:choose>
     </xsl:when>

     <xsl:otherwise>
      <xsl:value-of select="number($ParamImageInfo/@width)" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>
   <xsl:variable name="VarHeight">
    <xsl:choose>
     <xsl:when test="count($VarResolvedProperties[@Name = 'height']) = 0">
      <xsl:value-of select="0" />
     </xsl:when>

     <xsl:when test="$ParamThumbnail">
      <xsl:value-of select="number($ParamImageInfo/@height)" />
     </xsl:when>

     <xsl:when test="$ParamSplitsFrame/@byref = 'true'">
      <xsl:choose>
       <xsl:when test="$VarByReferenceGraphicsUseDocumentDimensions">
        <xsl:variable name="VarByReferenceFrame" select="$ParamFrame//wwdoc:Facet[@type = 'by-reference'][1]/../.." />

        <xsl:value-of select="floor(wwunits:Convert(wwunits:NumericPrefix($VarByReferenceFrame/wwdoc:Attribute[@name = 'height']/@value), 'pt', 'px'))" />
       </xsl:when>

       <xsl:otherwise>
        <xsl:value-of select="number($ParamImageInfo/@height)" />
       </xsl:otherwise>
      </xsl:choose>
     </xsl:when>

     <xsl:otherwise>
      <xsl:value-of select="number($ParamImageInfo/@height)" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <!-- Src -->
   <!--     -->
   <xsl:variable name="VarSrc" select="wwuri:GetRelativeTo($ParamImageInfo/@path, $ParamSplit/@path)" />

   <!-- Define Use Map -->
   <!--                -->
   <xsl:variable name="VarUseMap">
    <xsl:choose>
     <xsl:when test="($ParamThumbnail) or (count($ParamFrame//wwdoc:Link) &gt; 0)">
      <xsl:text>#</xsl:text>
      <xsl:value-of select="$ParamSplitsFrame/@documentID" />
      <xsl:text>_</xsl:text>
      <xsl:value-of select="$ParamSplitsFrame/@id" />
     </xsl:when>

     <xsl:otherwise>
      <xsl:value-of select="''" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <!-- Alt Text -->
   <!--          -->
   <xsl:variable name="VarAltText">
    <xsl:call-template name="Images-AltText">
     <xsl:with-param name="ParamFrame" select="$ParamFrame" />
     <xsl:with-param name="ParamBehaviorFrame" select="$VarBehaviorFrame" />
    </xsl:call-template>
   </xsl:variable>

   <!-- Long Description -->
   <!--                  -->
   <xsl:variable name="VarLongDescription">
    <xsl:call-template name="Images-LongDescription">
     <xsl:with-param name="ParamSplitsFrame" select="$ParamSplitsFrame" />
     <xsl:with-param name="ParamBehaviorFrame" select="$VarBehaviorFrame" />
    </xsl:call-template>
   </xsl:variable>

   <!-- Tag -->
   <!--     -->
   <xsl:variable name="VarTagProperty" select="$ParamContextRule/wwproject:Properties/wwproject:Property[@Name = 'tag']/@Value" />
   <xsl:variable name="VarTag">
    <xsl:choose>
     <xsl:when test="string-length($VarTagProperty) &gt; 0">
      <xsl:value-of select="$VarTagProperty" />
     </xsl:when>

     <xsl:otherwise>
      <xsl:value-of select="'img'" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <!-- Graphic element -->
   <!--                 -->
   <xsl:element name="{$VarTag}" namespace="{$GlobalDefaultNamespace}">
    <!-- Class attribute -->
    <!--                 -->
    <xsl:attribute name="class">
     <xsl:value-of select="wwstring:CSSClassName($ParamFrame/@stylename)" />

     <!-- Additional CSS classes -->
     <!--                        -->
     <xsl:variable name="VarAdditionalCSSClassesOption" select="normalize-space($ParamContextRule/wwproject:Options/wwproject:Option[@Name = 'additional-css-classes']/@Value)" />
     <xsl:if test="string-length($VarAdditionalCSSClassesOption) &gt; 0">
      <xsl:text> </xsl:text>
      <xsl:value-of select="$VarAdditionalCSSClassesOption" />
     </xsl:if>
    </xsl:attribute>

    <!-- Src attribute -->
    <!--               -->
    <xsl:attribute name="src">
     <xsl:value-of select="$VarSrc" />
    </xsl:attribute>

    <!-- Width attribute -->
    <!--                 -->
    <xsl:if test="$VarWidth &gt; 0">
     <xsl:attribute name="width">
      <xsl:value-of select="$VarWidth"/>
     </xsl:attribute>
    </xsl:if>

    <!-- Height attribute -->
    <!--                  -->
    <xsl:if test="$VarHeight &gt; 0">
     <xsl:attribute name="height">
      <xsl:value-of select="$VarHeight"/>
     </xsl:attribute>
    </xsl:if>

    <!-- Style attribute -->
    <!--                 -->
    <xsl:if test="string-length($VarInlineCSSProperties) &gt; 0">
     <xsl:attribute name="style">
      <xsl:value-of select="$VarInlineCSSProperties" />
     </xsl:attribute>
    </xsl:if>

    <!-- Alt attribute -->
    <!--               -->
    <xsl:attribute name="alt">
     <xsl:value-of select="$VarAltText" />
    </xsl:attribute>

    <!-- Longdesc attribute -->
    <!--                    -->
    <xsl:if test="string-length($VarLongDescription) &gt; 0">
     <xsl:attribute name="longdesc">
      <xsl:value-of select="$VarLongDescription" />
     </xsl:attribute>
    </xsl:if>

    <!-- Usemap attribute -->
    <!--                  -->
    <xsl:if test="string-length($VarUseMap) &gt; 0">
     <xsl:attribute name="usemap">
      <xsl:value-of select="$VarUseMap" />
     </xsl:attribute>
     <xsl:attribute name="border">
      <xsl:value-of select="'0'" />
     </xsl:attribute>
    </xsl:if>
   </xsl:element>

   <!-- Generate D Links -->
   <!--                  -->
   <xsl:variable name="VarGenerateDLinks" select="wwprojext:GetFormatSetting('accessibility-image-d-links', 'false')" />
   <xsl:if test="$VarGenerateDLinks = 'true'">
    <xsl:if test="string-length($VarLongDescription) &gt; 0">
     <xsl:text> </xsl:text>
     <html:a href="{$VarLongDescription}" title="{concat('Description link for ', wwfilesystem:GetFileName($ParamSplitsFrame/@path))}">[D]</html:a><html:br />
    </xsl:if>
   </xsl:if>

   <!-- Image map -->
   <!--           -->
   <xsl:if test="string-length($VarUseMap) &gt; 0">
    <html:map name="{concat($ParamSplitsFrame/@documentID, '_', $ParamSplitsFrame/@id)}">
     <xsl:choose>
      <!-- Thumbnail -->
      <!--           -->
      <xsl:when test="$ParamThumbnail">
       <html:area coords="{concat('0,0,', $VarWidth, ',', $VarHeight)}" shape="rect" href="{wwuri:GetRelativeTo($ParamSplitsFrame/wwsplits:Wrapper/@path, $ParamSplit/@path)}">
        <xsl:attribute name="alt">
         <xsl:value-of select="$VarAltText" />
        </xsl:attribute>
       </html:area>
      </xsl:when>

      <!-- Fullsize -->
      <!--          -->
      <xsl:otherwise>
       <xsl:variable name="VarHorizontalScalingAsText">
        <xsl:choose>
         <xsl:when test="$VarWidth &gt; 0">
          <xsl:variable name="VarWidthAsPixels" select="string(floor(wwunits:Convert(wwunits:NumericPrefix($ParamFrame/wwdoc:Attribute[@name = 'width']/@value), 'pt', 'px')))" />
          <xsl:value-of select="number($VarWidth) div number($VarWidthAsPixels)" />
         </xsl:when>

         <xsl:otherwise>
          <xsl:value-of select="1" />
         </xsl:otherwise>
        </xsl:choose>
       </xsl:variable>

       <xsl:variable name="VarVerticalScalingAsText">
        <xsl:choose>
         <xsl:when test="$VarHeight &gt; 0">
          <xsl:variable name="VarHeightAsPixels" select="string(floor(wwunits:Convert(wwunits:NumericPrefix($ParamFrame/wwdoc:Attribute[@name = 'height']/@value), 'pt', 'px')))" />
          <xsl:value-of select="number($VarHeight) div number($VarHeightAsPixels)" />
         </xsl:when>

         <xsl:otherwise>
          <xsl:value-of select="1" />
         </xsl:otherwise>
        </xsl:choose>
       </xsl:variable>

       <xsl:call-template name="ImageMap">
        <xsl:with-param name="ParamFrame" select="$ParamFrame" />
        <xsl:with-param name="ParamSplits" select="$ParamSplits" />
        <xsl:with-param name="ParamCargo" select="$ParamCargo" />
        <xsl:with-param name="ParamParentBehavior" select="$VarBehaviorFrame" />
        <xsl:with-param name="ParamLinks" select="$ParamLinks" />
        <xsl:with-param name="ParamSplit" select="$ParamSplit" />
        <xsl:with-param name="ParamHorizontalScaling" select="number($VarHorizontalScalingAsText)" />
        <xsl:with-param name="ParamVerticalScaling" select="number($VarVerticalScalingAsText)" />
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </html:map>
   </xsl:if>

   <!-- Notes -->
   <!--       -->
   <xsl:choose>
    <!-- Thumbnail -->
    <!--           -->
    <xsl:when test="$ParamThumbnail">
     <!-- Nothing to do -->
     <!--               -->
    </xsl:when>

    <!-- Fullsize -->
    <!--          -->
    <xsl:otherwise>
     <!-- Frame Footnotes -->
     <!--                 -->
     <xsl:variable name="VarNotes" select="$ParamFrame//wwdoc:Note" />
     <xsl:call-template name="Content-Notes">
      <xsl:with-param name="ParamNotes" select="$VarNotes" />
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamCargo" select="$ParamCargo" />
      <xsl:with-param name="ParamLinks" select="$ParamLinks" />
      <xsl:with-param name="ParamTOCData" select="''" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="ImageMap">
  <xsl:param name="ParamFrame" />
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamCargo" />
  <xsl:param name="ParamParentBehavior" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamHorizontalScaling" />
  <xsl:param name="ParamVerticalScaling" />

  <!-- Process child frames first -->
  <!--                            -->
  <xsl:for-each select="$ParamFrame/wwdoc:Content//wwdoc:Frame[count($ParamFrame | ancestor::wwdoc:Frame[1]) = 1]">
   <xsl:call-template name="ImageMap">
    <xsl:with-param name="ParamFrame" select="." />
    <xsl:with-param name="ParamSplits" select="$ParamSplits" />
    <xsl:with-param name="ParamCargo" select="$ParamCargo" />
    <xsl:with-param name="ParamParentBehavior" select="$ParamParentBehavior" />
    <xsl:with-param name="ParamLinks" select="$ParamLinks" />
    <xsl:with-param name="ParamSplit" select="$ParamSplit" />
    <xsl:with-param name="ParamHorizontalScaling" select="$ParamHorizontalScaling" />
    <xsl:with-param name="ParamVerticalScaling" select="$ParamVerticalScaling" />
   </xsl:call-template>
  </xsl:for-each>

  <!-- Get link -->
  <!--          -->
  <xsl:variable name="VarLinkInfoAsXML">
   <xsl:choose>
    <xsl:when test="count($ParamFrame/wwdoc:Link[1]) = 1">
     <xsl:call-template name="LinkInfo">
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamLinks" select="$ParamLinks" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
      <xsl:with-param name="ParamDocumentLink" select="$ParamFrame/wwdoc:Link" />
     </xsl:call-template>
    </xsl:when>

    <xsl:otherwise>
     <xsl:variable name="VarChildLinks" select="$ParamFrame/wwdoc:Content//wwdoc:Link[count($ParamFrame | ancestor::wwdoc:Frame[1]) = 1]" />
     <xsl:variable name="VarChildLinksCount" select="count($VarChildLinks)" />
     <xsl:if test="$VarChildLinksCount &gt; 0">
      <xsl:call-template name="LinkInfo">
       <xsl:with-param name="ParamSplits" select="$ParamSplits" />
       <xsl:with-param name="ParamLinks" select="$ParamLinks" />
       <xsl:with-param name="ParamSplit" select="$ParamSplit" />
       <xsl:with-param name="ParamDocumentLink" select="$VarChildLinks[$VarChildLinksCount]" />
      </xsl:call-template>
     </xsl:if>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <xsl:variable name="VarLinkInfo" select="msxsl:node-set($VarLinkInfoAsXML)/wwlinks:LinkInfo" />

  <xsl:if test="(string-length($VarLinkInfo/@href) &gt; 0) or (string-length($VarLinkInfo/@onMouseOver) &gt; 0)">
   <!-- Get coords attribute -->
   <!--                      -->
   <xsl:variable name="VarLeftAsPixels">
    <xsl:variable name="VarOrigLeftAsPixels" select="string(floor(wwunits:Convert(wwunits:NumericPrefix($ParamFrame/wwdoc:Attribute[@name = 'left']/@value), 'pt', 'px')))" />
    <xsl:choose>
     <xsl:when test="$ParamHorizontalScaling != 1">
      <xsl:value-of select="number($VarOrigLeftAsPixels) * number($ParamHorizontalScaling)" />
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="$VarOrigLeftAsPixels" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <xsl:variable name="VarTopAsPixels">
    <xsl:variable name="VarOrigTopAsPixels" select="string(floor(wwunits:Convert(wwunits:NumericPrefix($ParamFrame/wwdoc:Attribute[@name = 'top']/@value), 'pt', 'px')))" />
    <xsl:choose>
     <xsl:when test="$ParamVerticalScaling != 1">
      <xsl:value-of select="number($VarOrigTopAsPixels) * number($ParamVerticalScaling)" />
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="$VarOrigTopAsPixels" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <xsl:variable name="VarWidthAsPixels">
    <xsl:variable name="VarOrigWidthAsPixels" select="string(floor(wwunits:Convert(wwunits:NumericPrefix($ParamFrame/wwdoc:Attribute[@name = 'width']/@value), 'pt', 'px')))" />
    <xsl:choose>
     <xsl:when test="$ParamHorizontalScaling != 1">
      <xsl:value-of select="number($VarOrigWidthAsPixels) * number($ParamHorizontalScaling)" />
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="$VarOrigWidthAsPixels" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <xsl:variable name="VarHeightAsPixels">
    <xsl:variable name="VarOrigHeightAsPixels" select="string(floor(wwunits:Convert(wwunits:NumericPrefix($ParamFrame/wwdoc:Attribute[@name = 'height']/@value), 'pt', 'px')))" />
    <xsl:choose>
     <xsl:when test="$ParamVerticalScaling != 1">
      <xsl:value-of select="number($VarOrigHeightAsPixels) * number($ParamVerticalScaling)" />
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="$VarOrigHeightAsPixels" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <!-- coords -->
   <!--        -->
   <xsl:variable name="VarCoordsString">
    <xsl:choose>
     <xsl:when test="string-length($VarLeftAsPixels) &gt; 0">
      <xsl:value-of select="$VarLeftAsPixels" />
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="'0'" />
     </xsl:otherwise>
    </xsl:choose>

    <xsl:value-of select="','"/>

    <xsl:choose>
     <xsl:when test="string-length($VarTopAsPixels) &gt; 0">
      <xsl:value-of select="$VarTopAsPixels" />
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="'0'" />
     </xsl:otherwise>
    </xsl:choose>

    <xsl:value-of select="','"/>

    <xsl:choose>
     <xsl:when test="string-length($VarWidthAsPixels) &gt; 0">
      <xsl:value-of select="string(number($VarWidthAsPixels) + number($VarLeftAsPixels))" />
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="'0'" />
     </xsl:otherwise>
    </xsl:choose>

    <xsl:value-of select="','"/>

    <xsl:choose>
     <xsl:when test="string-length($VarHeightAsPixels) &gt; 0">
      <xsl:value-of select="string(number($VarHeightAsPixels) + number($VarTopAsPixels))" />
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="'0'" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <!-- alt -->
   <!--     -->
   <xsl:variable name="VarAltText">
    <xsl:call-template name="Images-ImageAreaAltText">
     <xsl:with-param name="ParamParentBehavior" select="$ParamParentBehavior" />
     <xsl:with-param name="ParamFrame" select="$ParamFrame" />
    </xsl:call-template>
   </xsl:variable>

   <!-- area -->
   <!--      -->
   <html:area href="{$VarLinkInfo/@href}" coords="{$VarCoordsString}" shape="rect">
    <!-- target -->
    <!--        -->
    <xsl:if test="string-length($VarLinkInfo/@target) &gt; 0">
     <xsl:attribute name="target">
      <xsl:value-of select="$VarLinkInfo/@target" />
     </xsl:attribute>
    </xsl:if>

    <!-- onMouseOver -->
    <!--             -->
    <xsl:if test="string-length($VarLinkInfo/@onMouseOver) &gt; 0">
     <xsl:attribute name="onMouseOver">
      <xsl:value-of select="$VarLinkInfo/@onMouseOver" />
     </xsl:attribute>
    </xsl:if>

    <!-- onMouseOut -->
    <!--            -->
    <xsl:if test="string-length($VarLinkInfo/@onMouseOut) &gt; 0">
     <xsl:attribute name="onMouseOut">
      <xsl:value-of select="$VarLinkInfo/@onMouseOut" />
     </xsl:attribute>
    </xsl:if>

    <!-- alt -->
    <!--     -->
    <xsl:attribute name="alt">
     <xsl:value-of select="$VarAltText" />
    </xsl:attribute>
   </html:area>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
